/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.RectangleLength2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.sorting.QuickSort_F64;

public class UtilPoint2D_F64 {
    public static List<Point2D_F64> copy(List<Point2D_F64> pts) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        for (Point2D_F64 p : pts) {
            ret.add(p.copy());
        }
        return ret;
    }

    public static void noiseNormal(List<Point2D_F64> pts, double sigma, Random rand) {
        for (Point2D_F64 p : pts) {
            p.x += rand.nextGaussian() * sigma;
            p.y += rand.nextGaussian() * sigma;
        }
    }

    public static double distance(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double distanceSq(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return dx * dx + dy * dy;
    }

    public static Point2D_F64 mean(List<Point2D_F64> list, Point2D_F64 mean) {
        if (mean == null) {
            mean = new Point2D_F64();
        }
        double x = 0.0;
        double y = 0.0;
        for (Point2D_F64 p : list) {
            x += p.getX();
            y += p.getY();
        }
        mean.set(x /= (double)list.size(), y /= (double)list.size());
        return mean;
    }

    public static Point2D_F64 mean(Point2D_F64[] list, int offset, int length, Point2D_F64 mean) {
        if (mean == null) {
            mean = new Point2D_F64();
        }
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < length; ++i) {
            Point2D_F64 p = list[offset + i];
            x += p.getX();
            y += p.getY();
        }
        mean.set(x /= (double)length, y /= (double)length);
        return mean;
    }

    public static Point2D_F64 mean(Point2D_F64 a, Point2D_F64 b, Point2D_F64 mean) {
        if (mean == null) {
            mean = new Point2D_F64();
        }
        mean.x = (a.x + b.x) / 2.0;
        mean.y = (a.y + b.y) / 2.0;
        return mean;
    }

    public static List<Point2D_F64> random(double min, double max, int num, Random rand) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        double d = max - min;
        for (int i = 0; i < num; ++i) {
            Point2D_F64 p = new Point2D_F64();
            p.x = rand.nextDouble() * d + min;
            p.y = rand.nextDouble() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static boolean isEquals(GeoTuple2D_F64 a, GeoTuple2D_F64 b, double tol) {
        return Math.abs(a.x - b.x) <= tol && Math.abs(a.x - b.x) <= tol;
    }

    public static RectangleLength2D_F64 bounding(List<Point2D_F64> points, RectangleLength2D_F64 bounding) {
        if (bounding == null) {
            bounding = new RectangleLength2D_F64();
        }
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (!(p.y > maxY)) continue;
            maxY = p.y;
        }
        bounding.x0 = minX;
        bounding.y0 = minY;
        bounding.width = maxX - minX;
        bounding.height = maxY - minY;
        bounding.width += Math.max(0.0, (maxX - (bounding.x0 + bounding.width)) * 10.0);
        bounding.height += Math.max(0.0, (maxY - (bounding.y0 + bounding.height)) * 10.0);
        return bounding;
    }

    public static Rectangle2D_F64 bounding(List<Point2D_F64> points, Rectangle2D_F64 bounding) {
        if (bounding == null) {
            bounding = new Rectangle2D_F64();
        }
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (p.x < minX) {
                minX = p.x;
            }
            if (p.x > maxX) {
                maxX = p.x;
            }
            if (p.y < minY) {
                minY = p.y;
            }
            if (!(p.y > maxY)) continue;
            maxY = p.y;
        }
        bounding.set(minX, minY, maxX, maxY);
        return bounding;
    }

    public static List<Point2D_F64> orderCCW(List<Point2D_F64> points) {
        Point2D_F64 center = UtilPoint2D_F64.mean(points, null);
        double[] angles = new double[points.size()];
        for (int i = 0; i < angles.length; ++i) {
            Point2D_F64 p = points.get(i);
            double dx = p.x - center.x;
            double dy = p.y - center.y;
            angles[i] = Math.atan2(dy, dx);
        }
        int[] order = new int[points.size()];
        QuickSort_F64 sorter = new QuickSort_F64();
        sorter.sort(angles, points.size(), order);
        ArrayList<Point2D_F64> out = new ArrayList<Point2D_F64>(points.size());
        for (int i = 0; i < points.size(); ++i) {
            out.add(points.get(order[i]));
        }
        return out;
    }
}

