/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.io.util;

import bayesnet.BayesianNetwork;
import bayesnet.Node;
import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.LinkedList;

public class BayesNetConverter {
    public BayesNet transform(BayesianNetwork network) {
        BayesNet bayesNet = new BayesNet();
        this.initializeNodes(network, bayesNet);
        this.initializeArcs(network, bayesNet);
        this.initializeProbabilities(network, bayesNet);
        return bayesNet;
    }

    private void initializeNodes(BayesianNetwork network, BayesNet bayesNet) {
        Collection<Node> nodes = network.getNodes();
        for (Node node : nodes) {
            BayesNode bayesNode = bayesNet.createNode(node.getIdentifier());
            String[] states = node.getStates();
            bayesNode.addOutcomes(states);
        }
    }

    private void initializeArcs(BayesianNetwork network, BayesNet bayesNet) {
        Collection<Node> nodes = network.getNodes();
        for (Node node : nodes) {
            Node[] parents = node.getParents();
            BayesNode children = bayesNet.getNode(node.getIdentifier());
            LinkedList<BayesNode> bnParents = new LinkedList<BayesNode>();
            for (int i = 0; i < parents.length; ++i) {
                bnParents.add(bayesNet.getNode(parents[i].getIdentifier()));
            }
            children.setParents(bnParents);
        }
    }

    private void initializeProbabilities(BayesianNetwork network, BayesNet bayesNet) {
        Collection<Node> nodes = network.getNodes();
        for (Node node : nodes) {
            BayesNode bayesNode = bayesNet.getNode(node.getIdentifier());
            bayesNode.setProbabilities(node.getProbabilities());
        }
    }

    public static Function<BayesianNetwork, BayesNet> asFunction() {
        return new Function<BayesianNetwork, BayesNet>(){
            private BayesNetConverter converter = new BayesNetConverter();

            public BayesNet apply(BayesianNetwork network) {
                return this.converter.transform(network);
            }
        };
    }
}

