/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeModel;

public class ComponentTableModel
extends AbstractTableModel {
    private List components = new ArrayList();

    @Override
    public int getRowCount() {
        return this.components.size();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Point.class;
            }
            case 2: {
                return Dimension.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Location";
            }
            case 2: {
                return "Size";
            }
        }
        return "Column " + column;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Component comp = (Component)this.components.get(row);
        switch (column) {
            case 0: {
                return this.convertValueToText(comp);
            }
            case 1: {
                return comp.getLocation();
            }
            case 2: {
                return comp.getSize();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void updateComponentList(TreeModel model) {
        this.components = new ArrayList();
        PreorderEnumeration enumeration = new PreorderEnumeration(model);
        while (enumeration.hasMoreElements()) {
            this.components.add(enumeration.nextElement());
        }
        this.fireTableDataChanged();
    }

    public String convertValueToText(Object node) {
        String className = node.getClass().getName();
        int lastDot = className.lastIndexOf(".");
        String lastElement = className.substring(lastDot + 1);
        return lastElement;
    }

    class PreorderEnumeration
    implements Enumeration {
        private TreeModel treeModel;
        protected Stack stack;

        public PreorderEnumeration(TreeModel treeModel) {
            this.treeModel = treeModel;
            Vector<Object> v = new Vector<Object>(1);
            v.addElement(treeModel.getRoot());
            this.stack = new Stack();
            this.stack.push(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && ((Enumeration)this.stack.peek()).hasMoreElements();
        }

        public Object nextElement() {
            ChildrenEnumeration children;
            Enumeration enumer = (Enumeration)this.stack.peek();
            Object node = enumer.nextElement();
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if ((children = new ChildrenEnumeration(this.treeModel, node)).hasMoreElements()) {
                this.stack.push(children);
            }
            return node;
        }
    }

    class ChildrenEnumeration
    implements Enumeration {
        TreeModel treeModel;
        Object node;
        int index = -1;

        public ChildrenEnumeration(TreeModel treeModel, Object node) {
            this.treeModel = treeModel;
            this.node = node;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.treeModel.getChildCount(this.node) - 1;
        }

        public Object nextElement() {
            return this.treeModel.getChild(this.node, ++this.index);
        }
    }
}

