/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class ActionMapTreeTableModel
extends DefaultTreeTableModel {
    public ActionMapTreeTableModel(JComponent comp) {
        this.setRoot(this.createRootNodeExt(comp));
        Vector<String> names = new Vector<String>();
        names.add("Key Name");
        names.add("Action Name");
        names.add("Action Command");
        this.setColumnIdentifiers(names);
    }

    private ActionEntryNode createRootNodeExt(JComponent comp) {
        ActionMap map = comp.getActionMap();
        if (map == null) {
            throw new IllegalArgumentException("Component must have ActionMap");
        }
        ArrayList<ActionMap> actionMaps = new ArrayList<ActionMap>();
        actionMaps.add(map);
        while ((map = map.getParent()) != null) {
            actionMaps.add(0, map);
        }
        return this.createActionEntryNodes(actionMaps);
    }

    private ActionEntryNode createActionEntryNodes(List actionMaps) {
        ActionEntryNode mapRoot;
        ActionMap topLevel = (ActionMap)actionMaps.get(0);
        ActionEntryNode current = mapRoot = new ActionEntryNode((Object)"topLevel", topLevel, null);
        for (int i = 1; i < actionMaps.size(); ++i) {
            current = current.addActionMapAsChild("childMap " + i, (ActionMap)actionMaps.get(i));
        }
        return mapRoot;
    }

    private static class ActionEntryNode
    implements TreeTableNode {
        ActionEntryNode parent;
        Object key;
        Action action;
        ActionMap actionMap;
        List<ActionEntryNode> children;

        public ActionEntryNode(Object key, Action action, ActionEntryNode parent) {
            this.parent = parent;
            this.key = key;
            this.action = action;
            this.children = Collections.EMPTY_LIST;
        }

        public ActionEntryNode(Object key, ActionMap map, ActionEntryNode parent) {
            this.parent = parent;
            this.key = key;
            this.actionMap = map;
            this.children = new ArrayList<ActionEntryNode>();
            Object[] keys = map.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.children.add(new ActionEntryNode(keys[i], map.get(keys[i]), this));
            }
        }

        public ActionEntryNode addActionMapAsChild(Object key, ActionMap map) {
            ActionEntryNode actionEntryNode = new ActionEntryNode(key, map, this);
            this.getChildren().add(0, actionEntryNode);
            return actionEntryNode;
        }

        public List<ActionEntryNode> getChildren() {
            return this.children;
        }

        public ActionMap getActionMap() {
            return this.actionMap;
        }

        public Action getAction() {
            return this.action;
        }

        public String toString() {
            return this.key.toString();
        }

        @Override
        public boolean isLeaf() {
            return this.action != null;
        }

        @Override
        public boolean getAllowsChildren() {
            return !this.isLeaf();
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public Enumeration<? extends TreeTableNode> children() {
            return Collections.enumeration(this.children);
        }

        @Override
        public TreeTableNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public TreeTableNode getParent() {
            return this.parent;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int column) {
            ActionEntryNode actionNode = this;
            switch (column) {
                case 0: {
                    return actionNode.key;
                }
                case 1: {
                    if (actionNode.isLeaf()) {
                        return actionNode.getAction().getValue("Name");
                    }
                    return null;
                }
                case 2: {
                    if (!actionNode.isLeaf()) break;
                    return actionNode.getAction().getValue("ActionCommandKey");
                }
            }
            return null;
        }

        @Override
        public boolean isEditable(int column) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int column) {
        }

        @Override
        public Object getUserObject() {
            return this.getAction();
        }

        @Override
        public void setUserObject(Object userObject) {
        }
    }
}

