/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.eval;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FloatNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.NumberNode;
import org.matheclipse.parser.client.ast.PatternNode;
import org.matheclipse.parser.client.ast.StringNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.eval.BooleanVariable;
import org.matheclipse.parser.client.eval.ComplexNode;
import org.matheclipse.parser.client.eval.ComplexVariable;
import org.matheclipse.parser.client.eval.DoubleNode;
import org.matheclipse.parser.client.eval.IBooleanBoolean1Function;
import org.matheclipse.parser.client.eval.IBooleanBoolean2Function;
import org.matheclipse.parser.client.eval.IBooleanComplex2Function;
import org.matheclipse.parser.client.eval.IComplex0Function;
import org.matheclipse.parser.client.eval.IComplex1Function;
import org.matheclipse.parser.client.eval.IComplex2Function;
import org.matheclipse.parser.client.eval.IComplexFunction;
import org.matheclipse.parser.client.eval.api.AbstractASTVisitor;
import org.matheclipse.parser.client.eval.api.IEvaluator;
import org.matheclipse.parser.client.math.ArithmeticMathException;
import org.matheclipse.parser.client.math.Complex;
import org.matheclipse.parser.client.math.MathException;

public class ComplexEvalVisitor
extends AbstractASTVisitor<Complex, ComplexVariable, Complex> {
    public static final boolean DEBUG = false;
    private static Map<String, Complex> SYMBOL_MAP = new ConcurrentHashMap<String, Complex>();
    private static Map<String, Boolean> SYMBOL_BOOLEAN_MAP;
    private static Map<String, Object> FUNCTION_MAP;
    private static Map<String, Object> FUNCTION_BOOLEAN_MAP;
    private Map<String, ComplexVariable> fVariableMap = new HashMap<String, ComplexVariable>();
    private Map<String, BooleanVariable> fBooleanVariables = new HashMap<String, BooleanVariable>();
    private final boolean fRelaxedSyntax;

    public ComplexEvalVisitor(boolean relaxedSyntax) {
        this.fRelaxedSyntax = relaxedSyntax;
        if (this.fRelaxedSyntax && SYMBOL_MAP.get("pi") == null) {
            for (String key : SYMBOL_MAP.keySet()) {
                SYMBOL_MAP.put(key.toLowerCase(), SYMBOL_MAP.get(key));
            }
            for (String key : SYMBOL_BOOLEAN_MAP.keySet()) {
                SYMBOL_BOOLEAN_MAP.put(key.toLowerCase(), SYMBOL_BOOLEAN_MAP.get(key));
            }
            for (String key : FUNCTION_MAP.keySet()) {
                FUNCTION_MAP.put(key.toLowerCase(), FUNCTION_MAP.get(key));
            }
            for (String key : FUNCTION_BOOLEAN_MAP.keySet()) {
                FUNCTION_BOOLEAN_MAP.put(key.toLowerCase(), FUNCTION_BOOLEAN_MAP.get(key));
            }
        }
    }

    public Complex getResult() {
        return null;
    }

    @Override
    public void setUp(Complex data) {
    }

    @Override
    public void tearDown() {
    }

    @Override
    public Complex visit(ComplexNode node) {
        return node.complexValue();
    }

    @Override
    public Complex visit(DoubleNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(FloatNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(FractionNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (symbol.equals("If") || this.fRelaxedSyntax && symbol.equalsIgnoreCase("If")) {
                if (functionNode.size() == 3) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return (Complex)this.evaluateNode(functionNode.getNode(2));
                    }
                } else if (functionNode.size() == 4) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return (Complex)this.evaluateNode(functionNode.getNode(2));
                    }
                    return (Complex)this.evaluateNode(functionNode.getNode(3));
                }
            } else {
                Object obj = FUNCTION_MAP.get(symbol);
                if (obj instanceof IComplexFunction) {
                    return ((IComplexFunction)obj).evaluate(this, functionNode);
                }
                if (functionNode.size() == 1) {
                    if (obj instanceof IComplex0Function) {
                        return ((IComplex0Function)obj).evaluate();
                    }
                } else if (functionNode.size() == 2) {
                    if (obj instanceof IComplex1Function) {
                        return ((IComplex1Function)obj).evaluate((Complex)this.evaluateNode(functionNode.getNode(1)));
                    }
                } else if (functionNode.size() == 3 && obj instanceof IComplex2Function) {
                    return ((IComplex2Function)obj).evaluate((Complex)this.evaluateNode(functionNode.getNode(1)), (Complex)this.evaluateNode(functionNode.getNode(2)));
                }
            }
        }
        throw new MathException("EvalDouble#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public Complex visit(IntegerNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(PatternNode node) {
        return null;
    }

    @Override
    public Complex visit(StringNode node) {
        return null;
    }

    @Override
    public Complex visit(SymbolNode node) {
        ComplexVariable v = this.fVariableMap.get(node.toString());
        if (v != null) {
            return v.getValue();
        }
        Complex c = SYMBOL_MAP.get(node.toString());
        if (c != null) {
            return c;
        }
        throw new MathException("ComplexEvalVisitor#visit(SymbolNode) not possible for: " + node.toString());
    }

    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            BooleanVariable v = this.fBooleanVariables.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Boolean boole = SYMBOL_BOOLEAN_MAP.get(node.toString());
            if (boole != null) {
                return boole;
            }
        }
        throw new ArithmeticMathException("EvalDouble#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (functionNode.size() == 2) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)));
                }
            } else if (functionNode.size() == 3) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanComplex2Function) {
                    return ((IBooleanComplex2Function)obj).evaluate((Complex)this.evaluateNode(functionNode.getNode(1)), (Complex)this.evaluateNode(functionNode.getNode(2)));
                }
                if (obj instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)), this.evaluateNodeLogical(functionNode.getNode(2)));
                }
            }
        }
        throw new ArithmeticMathException("EvalDouble#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    @Override
    public void defineVariable(String variableName, ComplexVariable value) {
        this.fVariableMap.put(variableName, value);
    }

    @Override
    public ComplexVariable getVariable(String variableName) {
        return this.fVariableMap.get(variableName);
    }

    @Override
    public void defineVariable(String variableName, BooleanVariable value) {
        this.fBooleanVariables.put(variableName, value);
    }

    @Override
    public void clearVariables() {
        this.fVariableMap.clear();
    }

    @Override
    public ASTNode optimizeFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0) {
            boolean complexOnly = true;
            for (int i = 1; i < functionNode.size(); ++i) {
                ASTNode node = functionNode.getNode(i);
                if (node instanceof NumberNode) {
                    functionNode.set(i, new ComplexNode(((NumberNode)functionNode.getNode(i)).doubleValue()));
                    continue;
                }
                if (functionNode.getNode(i) instanceof FunctionNode) {
                    ASTNode optNode = this.optimizeFunction((FunctionNode)functionNode.getNode(i));
                    if (!(optNode instanceof ComplexNode)) {
                        complexOnly = false;
                    }
                    functionNode.set(i, optNode);
                    continue;
                }
                if (node instanceof SymbolNode) {
                    Complex c = SYMBOL_MAP.get(node.toString());
                    if (c != null) {
                        functionNode.set(i, new ComplexNode(c));
                        continue;
                    }
                    complexOnly = false;
                    continue;
                }
                complexOnly = false;
            }
            if (complexOnly) {
                try {
                    return new ComplexNode(this.visit(functionNode));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return functionNode;
    }

    static {
        SYMBOL_MAP.put("Catalan", new Complex(0.915965594177219, 0.0));
        SYMBOL_MAP.put("Degree", new Complex(Math.PI / 180, 0.0));
        SYMBOL_MAP.put("E", new Complex(Math.E, 0.0));
        SYMBOL_MAP.put("I", new Complex(0.0, 1.0));
        SYMBOL_MAP.put("Pi", new Complex(Math.PI, 0.0));
        SYMBOL_MAP.put("EulerGamma", new Complex(0.5772156649015329, 0.0));
        SYMBOL_MAP.put("Glaisher", new Complex(1.2824271291006226, 0.0));
        SYMBOL_MAP.put("GoldenRatio", new Complex(1.618033988749895, 0.0));
        SYMBOL_MAP.put("Khinchin", new Complex(2.6854520010653062, 0.0));
        SYMBOL_BOOLEAN_MAP = new ConcurrentHashMap<String, Boolean>();
        SYMBOL_BOOLEAN_MAP.put("False", Boolean.FALSE);
        SYMBOL_BOOLEAN_MAP.put("True", Boolean.TRUE);
        FUNCTION_BOOLEAN_MAP = new ConcurrentHashMap<String, Object>();
        FUNCTION_BOOLEAN_MAP.put("And", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", new IBooleanBoolean1Function(){

            @Override
            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", new IBooleanComplex2Function(){

            @Override
            public boolean evaluate(Complex arg1, Complex arg2) {
                return arg1.equals(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", new IBooleanComplex2Function(){

            @Override
            public boolean evaluate(Complex arg1, Complex arg2) {
                return !arg1.equals(arg2);
            }
        });
        FUNCTION_MAP = new ConcurrentHashMap<String, Object>();
        FUNCTION_MAP.put("ArcTan", new ArcTanFunction());
        FUNCTION_MAP.put("Log", new LogFunction());
        FUNCTION_MAP.put("CompoundExpression", new CompoundExpressionFunction());
        FUNCTION_MAP.put("Set", new SetFunction());
        FUNCTION_MAP.put("Plus", new PlusFunction());
        FUNCTION_MAP.put("Times", new TimesFunction());
        FUNCTION_MAP.put("Random", new IComplex0Function(){

            @Override
            public Complex evaluate() {
                return new Complex(Math.random(), Math.random());
            }
        });
        FUNCTION_MAP.put("ArcCos", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.acos();
            }
        });
        FUNCTION_MAP.put("ArcSin", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.asin();
            }
        });
        FUNCTION_MAP.put("Cos", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.cos();
            }
        });
        FUNCTION_MAP.put("Cosh", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.cosh();
            }
        });
        FUNCTION_MAP.put("Exp", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.exp();
            }
        });
        FUNCTION_MAP.put("Sin", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.sin();
            }
        });
        FUNCTION_MAP.put("Sinh", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.sinh();
            }
        });
        FUNCTION_MAP.put("Sqrt", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.sqrt();
            }
        });
        FUNCTION_MAP.put("Tan", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.tan();
            }
        });
        FUNCTION_MAP.put("Tanh", new IComplex1Function(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.tanh();
            }
        });
        FUNCTION_MAP.put("Power", new IComplex2Function(){

            @Override
            public Complex evaluate(Complex arg1, Complex arg2) {
                return arg1.pow(arg2);
            }
        });
    }

    static class TimesFunction
    implements IComplexFunction,
    IComplex2Function {
        TimesFunction() {
        }

        @Override
        public Complex evaluate(Complex arg1, Complex arg2) {
            return arg1.multiply(arg2);
        }

        @Override
        public Complex evaluate(IEvaluator<Complex, ComplexVariable> engine, FunctionNode function) {
            Complex result = new Complex(1.0, 0.0);
            for (int i = 1; i < function.size(); ++i) {
                result = result.multiply(engine.evaluateNode(function.getNode(i)));
            }
            return result;
        }
    }

    static class PlusFunction
    implements IComplexFunction,
    IComplex2Function {
        PlusFunction() {
        }

        @Override
        public Complex evaluate(Complex arg1, Complex arg2) {
            return arg1.add(arg2);
        }

        @Override
        public Complex evaluate(IEvaluator<Complex, ComplexVariable> engine, FunctionNode function) {
            Complex result = new Complex(0.0, 0.0);
            for (int i = 1; i < function.size(); ++i) {
                result = result.add(engine.evaluateNode(function.getNode(i)));
            }
            return result;
        }
    }

    static class SetFunction
    implements IComplexFunction {
        SetFunction() {
        }

        @Override
        public Complex evaluate(IEvaluator<Complex, ComplexVariable> engine, FunctionNode function) {
            if (function.size() != 3) {
                throw new ArithmeticMathException("SetFunction#evaluate(DoubleEvaluator,FunctionNode) needs 2 arguments: " + function.toString());
            }
            if (!(function.getNode(1) instanceof SymbolNode)) {
                throw new ArithmeticMathException("SetFunction#evaluate(DoubleEvaluator,FunctionNode) symbol required on the left hand side: " + function.toString());
            }
            String variableName = ((SymbolNode)function.getNode(1)).getString();
            Complex result = engine.evaluateNode(function.getNode(2));
            ComplexVariable dv = engine.getVariable(variableName);
            if (dv == null) {
                dv = new ComplexVariable(result);
            } else {
                dv.setValue(result);
            }
            engine.defineVariable(variableName, dv);
            return result;
        }
    }

    static class CompoundExpressionFunction
    implements IComplexFunction {
        CompoundExpressionFunction() {
        }

        @Override
        public Complex evaluate(IEvaluator<Complex, ComplexVariable> engine, FunctionNode function) {
            Complex result = null;
            int end = function.size();
            for (int i = 1; i < end; ++i) {
                result = engine.evaluateNode(function.getNode(i));
            }
            return result;
        }
    }

    static class LogFunction
    implements IComplex1Function,
    IComplex2Function {
        LogFunction() {
        }

        @Override
        public Complex evaluate(Complex arg1) {
            return arg1.log();
        }

        @Override
        public Complex evaluate(Complex base, Complex z) {
            return z.log().divide(base.log());
        }
    }

    static class ArcTanFunction
    implements IComplex1Function {
        ArcTanFunction() {
        }

        @Override
        public Complex evaluate(Complex arg1) {
            return arg1.atan();
        }
    }
}

