/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.stat.descriptive.summary;

import java.io.Serializable;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.stat.descriptive.AbstractSymbolicStorelessUnivariateStatistic;

public class SymbolicSumOfLogs
extends AbstractSymbolicStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -370076995648386763L;
    private int n = 0;
    private IExpr value = F.C0;

    @Override
    public void increment(IExpr d) {
        this.value = F.eval(F.Plus(this.value, (IExpr)F.Log(d)));
        ++this.n;
    }

    @Override
    public IExpr getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = F.C0;
        this.n = 0;
    }

    @Override
    public IExpr evaluate(IAST values, int begin, int length) {
        if (this.test(values, begin, length, true)) {
            IAST sumLog = F.Plus();
            for (int i = begin; i < begin + length; ++i) {
                sumLog.add(F.Log((IExpr)values.get(i)));
            }
            if (sumLog.size() > 1) {
                return F.eval(sumLog);
            }
        }
        return null;
    }
}

