/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.stat.descriptive;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.stat.descriptive.StorelessSymbolicUnivariateStatistic;

public abstract class AbstractSymbolicStorelessUnivariateStatistic
implements StorelessSymbolicUnivariateStatistic {
    @Override
    public IExpr evaluate(IAST values) {
        if (values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return this.evaluate(values, 1, values.size() - 1);
    }

    @Override
    public IExpr evaluate(IAST values, int begin, int length) {
        if (this.test(values, begin, length)) {
            this.clear();
            this.incrementAll(values, begin, length);
        }
        return this.getResult();
    }

    @Override
    public abstract long getN();

    @Override
    public abstract void clear();

    @Override
    public abstract IExpr getResult();

    @Override
    public abstract void increment(IExpr var1);

    @Override
    public void incrementAll(IAST values) {
        if (values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        this.incrementAll(values, 1, values.size() - 1);
    }

    @Override
    public void incrementAll(IAST values, int begin, int length) {
        if (this.test(values, begin, length)) {
            int k = begin + length;
            for (int i = begin; i < k; ++i) {
                this.increment((IExpr)values.get(i));
            }
        }
    }

    protected boolean test(IAST values, int begin, int length) {
        return this.test(values, begin, length, false);
    }

    protected boolean test(IAST values, int begin, int length, boolean allowEmpty) {
        if (values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, (Number)begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, (Number)length);
        }
        if (begin + length > values.size()) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), (Number)values.size(), true);
        }
        return length != 0 || allowEmpty;
    }

    protected boolean test(IAST values, IAST weights, int begin, int length) {
        return this.test(values, weights, begin, length, false);
    }

    protected boolean test(IAST values, IAST weights, int begin, int length, boolean allowEmpty) {
        if (weights == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (weights.size() != values.size()) {
            throw new DimensionMismatchException(weights.size(), values.size());
        }
        boolean containsPositiveWeight = false;
        for (int i = begin; i < begin + length; ++i) {
        }
        if (!containsPositiveWeight) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        return this.test(values, begin, length, allowEmpty);
    }
}

