/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class TrigExpand
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        Validate.checkSize(ast, 2);
        IExpr result = temp = ast.arg1();
        while (temp != null) {
            result = F.evalExpandAll(temp);
            temp = null;
            if (result.isAST() && ((IAST)result).size() == 2) {
                IInteger iNum;
                IAST timesAST;
                if (result.getAt(1).isPlus()) {
                    if (result.isSin()) {
                        temp = this.expandSinPlus((IAST)result.getAt(1), 1);
                    } else if (result.isCos()) {
                        temp = this.expandCosPlus((IAST)result.getAt(1), 1);
                    }
                } else if (result.getAt(1).isTimes() && (timesAST = (IAST)result.getAt(1)).arg1().isInteger() && (iNum = (IInteger)timesAST.arg1()).isGreaterThan(F.C0)) {
                    IAST rest = F.Times();
                    rest.addAll(timesAST, 2, timesAST.size());
                    if (result.isSin()) {
                        return F.Sum(F.Times((IExpr)F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.CN1, F.Times((IExpr)F.Plus((IExpr)F.$s("i"), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C1)), (IExpr)F.C1D2)), (IExpr)F.Binomial(iNum, F.$s("i"))), (IExpr)F.Power((IExpr)F.Cos(rest), F.Plus((IExpr)iNum, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.$s("i"))))), (IExpr)F.Power((IExpr)F.Sin(rest), F.$s("i"))), F.List(F.$s("i"), F.C1, iNum, F.C2));
                    }
                    if (result.isCos()) {
                        return F.Sum(F.Times((IExpr)F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.CN1, F.Times((IExpr)F.$s("i"), (IExpr)F.C1D2)), (IExpr)F.Binomial(iNum, F.$s("i"))), (IExpr)F.Power((IExpr)F.Cos(rest), F.Plus((IExpr)iNum, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.$s("i"))))), (IExpr)F.Power((IExpr)F.Sin(rest), F.$s("i"))), F.List(F.$s("i"), F.C0, iNum, F.C2));
                    }
                }
            }
            if (temp == null) continue;
            result = temp;
        }
        return result;
    }

    private IExpr expandSinPlus(IAST plusAST, int startPosition) {
        if (startPosition > plusAST.size() - 2) {
            return null;
        }
        IAST result = F.Plus();
        if (startPosition == plusAST.size() - 2) {
            result.add(F.Times((IExpr)F.Sin((IExpr)plusAST.get(startPosition)), (IExpr)F.Cos((IExpr)plusAST.get(startPosition + 1))));
            result.add(F.Times((IExpr)F.Cos((IExpr)plusAST.get(startPosition)), (IExpr)F.Sin((IExpr)plusAST.get(startPosition + 1))));
        } else {
            result.add(F.Times((IExpr)F.Sin((IExpr)plusAST.get(startPosition)), this.expandCosPlus(plusAST, startPosition + 1)));
            result.add(F.Times((IExpr)F.Cos((IExpr)plusAST.get(startPosition)), this.expandSinPlus(plusAST, startPosition + 1)));
        }
        return result;
    }

    private IExpr expandCosPlus(IAST plusAST, int startPosition) {
        if (startPosition > plusAST.size() - 2) {
            return null;
        }
        IAST result = F.Plus();
        if (startPosition == plusAST.size() - 2) {
            result.add(F.Times((IExpr)F.Cos((IExpr)plusAST.get(startPosition)), (IExpr)F.Cos((IExpr)plusAST.get(startPosition + 1))));
            result.add(F.Times(F.CN1, F.Sin((IExpr)plusAST.get(startPosition)), F.Sin((IExpr)plusAST.get(startPosition + 1))));
        } else {
            result.add(F.Times((IExpr)F.Cos((IExpr)plusAST.get(startPosition)), this.expandCosPlus(plusAST, startPosition + 1)));
            result.add(F.Times(F.CN1, F.Sin((IExpr)plusAST.get(startPosition)), this.expandSinPlus(plusAST, startPosition + 1)));
        }
        return result;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }
}

