/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class ToCharacterCode
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        if (!(ast.arg1() instanceof IStringX)) {
            return null;
        }
        IAST resultList = F.List();
        resultList = (IAST)ToCharacterCode.toCharacterCode(ast.arg1().toString(), "UTF-8", resultList);
        return resultList;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    public static List<IExpr> toCharacterCode(String unicodeInput, String inputEncoding, List<IExpr> list) {
        try {
            String utf8String = new String(unicodeInput.getBytes(inputEncoding), "UTF-8");
            for (int i = 0; i < utf8String.length(); ++i) {
                char characterCode = utf8String.charAt(i);
                list.add(F.integer(characterCode));
            }
            return list;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

