/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Taylor
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() == 3 && ast.arg2().isVector() == 3) {
            IAST list = (IAST)ast.arg2();
            int lowerLimit = Validate.checkIntType(list, 2, Integer.MIN_VALUE);
            if (lowerLimit != 0) {
                return null;
            }
            int upperLimit = Validate.checkIntType(list, 3, Integer.MIN_VALUE);
            if (upperLimit < 0) {
                return null;
            }
            IAST fadd = F.Plus();
            fadd.add(F.ReplaceAll(ast.arg1(), F.Rule(list.arg1(), list.arg2())));
            IExpr temp = ast.arg1();
            IAST factor = null;
            for (int i = 1; i <= upperLimit; ++i) {
                temp = F.D(temp, list.arg1());
                factor = F.Times((IExpr)F.Power((IExpr)F.Factorial(F.integer(i)), F.CN1), (IExpr)F.Power((IExpr)F.Plus(list.arg1(), (IExpr)F.Times((IExpr)F.CN1, list.arg2())), F.integer(i)));
                fadd.add(F.Times((IExpr)F.ReplaceAll(temp, F.Rule(list.arg1(), list.arg2())), (IExpr)factor));
            }
            return fadd;
        }
        return null;
    }
}

