/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.ISequence;
import org.matheclipse.core.eval.util.Sequence;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Take
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        try {
            if (ast.arg1().isAST()) {
                ISequence[] sequ = Sequence.createSequences(ast, 2);
                IAST arg1 = (IAST)ast.arg1();
                if (sequ != null) {
                    return this.take(arg1, 0, sequ);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public IAST take(IAST list, int level, ISequence[] sequ) {
        sequ[level].setListSize(list.size());
        IAST resultList = list.copyHead();
        int newLevel = level + 1;
        for (int i = sequ[level].getStart(); i < sequ[level].getEnd(); i += sequ[level].getStep()) {
            if (sequ.length > newLevel) {
                if (!((IExpr)list.get(i)).isAST()) continue;
                resultList.add(this.take((IAST)list.get(i), newLevel, sequ));
                continue;
            }
            resultList.add(list.get(i));
        }
        return resultList;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(16384);
    }
}

