/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.ICreatePatternMatcher;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class SetDelayed
implements IFunctionEvaluator,
ICreatePatternMatcher {
    public static final SetDelayed CONST = new SetDelayed();

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IExpr leftHandSide = ast.arg1();
        IExpr rightHandSide = ast.arg2();
        this.createPatternMatcher(leftHandSide, rightHandSide, EvalEngine.get().isPackageMode());
        return F.Null;
    }

    @Override
    public Object[] createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) throws RuleCreationError {
        if (leftHandSide.isAST() && (((IAST)leftHandSide).getEvalFlags() & 0x300) == 0) {
            leftHandSide = PatternMatcher.evalLeftHandSide((IAST)leftHandSide, EvalEngine.get());
        }
        Object[] result = new Object[]{null, rightHandSide};
        if (leftHandSide.isAST()) {
            ISymbol lhsSymbol = ((IAST)leftHandSide).topHead();
            result[0] = lhsSymbol.putDownRule(F.SetDelayed, false, leftHandSide, rightHandSide, packageMode);
            return result;
        }
        if (leftHandSide.isSymbol()) {
            ISymbol lhsSymbol = (ISymbol)leftHandSide;
            if (lhsSymbol.hasLocalVariableStack()) {
                lhsSymbol.set(rightHandSide);
                return result;
            }
            result[0] = lhsSymbol.putDownRule(F.SetDelayed, true, leftHandSide, rightHandSide, packageMode);
            return result;
        }
        throw new RuleCreationError(leftHandSide);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

