/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.Map;
import org.matheclipse.core.visit.VisitorLevelSpecification;

public class Scan
extends Map {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 5);
        int lastIndex = ast.size() - 1;
        boolean heads = false;
        Options options = new Options(ast.topHead(), ast, lastIndex);
        IExpr option = options.getOption("Heads");
        if (option != null) {
            --lastIndex;
            if (option.isTrue()) {
                heads = true;
            }
        } else {
            Validate.checkRange(ast, 3, 4);
        }
        try {
            IAST arg1 = F.ast(ast.arg1());
            if (lastIndex == 3) {
                IAST result = F.List();
                Function<IExpr, IExpr> sf = Functors.scan(arg1, result);
                VisitorLevelSpecification level = new VisitorLevelSpecification(sf, (IExpr)ast.get(lastIndex), heads);
                ((IExpr)ast.get(2)).accept(level);
                for (int i = 1; i < result.size(); ++i) {
                    F.eval((IExpr)result.get(i));
                }
            } else if (((IExpr)ast.get(2)).isAST()) {
                F.eval(((IAST)ast.arg2()).map(Functors.append(arg1)));
            } else {
                F.eval(ast.arg2());
            }
            return F.Null;
        }
        catch (ReturnException e) {
            return e.getValue();
        }
    }
}

