/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.CoefficientList;
import org.matheclipse.parser.client.SyntaxError;

public class Resultant
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 4);
        IExpr arg1 = F.evalExpandAll(ast.arg1());
        IExpr arg2 = F.evalExpandAll(ast.arg2());
        IExpr arg3 = ast.arg3();
        if (!arg3.isSymbol()) {
            return null;
        }
        try {
            IAST result = F.List();
            long degree1 = CoefficientList.univariateCoefficientList(arg1, (ISymbol)arg3, result);
            if (degree1 >= 32767L) {
                throw new WrongArgumentType(ast, (IExpr)ast.get(1), 1, "Polynomial degree" + degree1 + " is larger than: " + " - " + Short.MAX_VALUE);
            }
            IAST resultListDiff = F.List();
            long degree2 = CoefficientList.univariateCoefficientList(arg2, (ISymbol)arg3, resultListDiff);
            if (degree2 >= 32767L) {
                throw new WrongArgumentType(ast, (IExpr)ast.get(1), 1, "Polynomial degree" + degree2 + " is larger than: " + " - " + Short.MAX_VALUE);
            }
            return Resultant.resultant(result, resultListDiff);
        }
        catch (JASConversionException jce) {
            return null;
        }
    }

    public static IExpr resultant(IAST result, IAST resultListDiff) {
        int j;
        IAST srow;
        int i;
        IAST sylvester = F.List();
        IAST row = F.List();
        int n = resultListDiff.size() - 2;
        int m = result.size() - 2;
        int n2 = m + n;
        for (i = result.size() - 1; i > 0; --i) {
            row.add(result.get(i));
        }
        for (i = 0; i < n; ++i) {
            srow = F.List();
            j = 0;
            while (j < n2) {
                if (j < i) {
                    srow.add(F.C0);
                    ++j;
                    continue;
                }
                if (i == j) {
                    for (int j2 = 1; j2 < row.size(); ++j2) {
                        srow.add(row.get(j2));
                        ++j;
                    }
                    continue;
                }
                srow.add(F.C0);
                ++j;
            }
            sylvester.add(srow);
        }
        row = F.List();
        for (i = resultListDiff.size() - 1; i > 0; --i) {
            row.add(resultListDiff.get(i));
        }
        for (i = n; i < n2; ++i) {
            srow = F.List();
            j = 0;
            int k = n;
            while (j < n2) {
                if (k < i) {
                    srow.add(F.C0);
                    ++j;
                    ++k;
                    continue;
                }
                if (i == k) {
                    for (int j2 = 1; j2 < row.size(); ++j2) {
                        srow.add(row.get(j2));
                        ++j;
                        ++k;
                    }
                    continue;
                }
                srow.add(F.C0);
                ++j;
                ++k;
            }
            sylvester.add(srow);
        }
        if (sylvester.size() == 1) {
            return null;
        }
        return F.eval(F.Det(sylvester));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }
}

