/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Pochhammer
extends AbstractArg2 {
    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        BigFraction bf;
        BigFraction ph;
        if (o0.isRational() && o1.isInteger() && (ph = Pochhammer.pochhammer(bf = ((IRational)o0).getFraction(), ((IInteger)o1).getBigNumerator())) != null) {
            return F.fraction(ph);
        }
        return null;
    }

    public static BigFraction pochhammer(BigFraction th, BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        if (n.compareTo(BigInteger.ZERO) == 0) {
            return BigFraction.ONE;
        }
        BigFraction res = new BigFraction(th.getNumerator(), th.getDenominator());
        BigInteger i = BigInteger.ONE;
        while (i.compareTo(n) < 0) {
            res = res.multiply(th.add(i));
            i = i.add(BigInteger.ONE);
        }
        return res;
    }

    public static BigFraction pochhammer(BigFraction th, int n) {
        return Pochhammer.pochhammer(th, BigInteger.valueOf(n));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
    }
}

