/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractArgMultiple;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.HashedOrderlessMatcher;

public class Plus
extends AbstractArgMultiple
implements INumeric {
    public static final Plus CONST = new Plus();
    private static HashedOrderlessMatcher ORDERLESS_MATCHER = new HashedOrderlessMatcher(true);

    @Override
    public HashedOrderlessMatcher getHashRuleMap() {
        return ORDERLESS_MATCHER;
    }

    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return c0.add(c1);
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        return d0.add(d1);
    }

    @Override
    public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
        return d0.add(d1);
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        return f0.add(f1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        return i0.add(i1);
    }

    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        IAST f1;
        if (o0.isZero()) {
            return o1;
        }
        if (o1.isZero()) {
            return o0;
        }
        if (o0.equals(F.Indeterminate) || o1.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        IExpr temp = null;
        if (o0.isInfinity() || o0.isNegativeInfinity()) {
            temp = this.eInfinity(o0, o1);
        } else if (o1.isInfinity() || o1.isNegativeInfinity()) {
            temp = this.eInfinity(o1, o0);
        }
        if (temp != null) {
            return temp;
        }
        if (o0.equals(o1)) {
            return F.Times((IExpr)F.C2, o0);
        }
        if (o0.isTimes()) {
            AST f12;
            AST f0 = (AST)o0;
            if (f0.arg1().isNumber()) {
                if (f0.size() == 3 && f0.arg2().equals(o1)) {
                    return F.Times((IExpr)F.Plus((IExpr)F.C1, f0.arg1()), o1);
                }
                if (o1.isTimes()) {
                    AST f13 = (AST)o1;
                    if (f13.arg1().isNumber()) {
                        if (f0.equalsFromPosition(1, f13, 1)) {
                            IAST result = F.ast(f0, F.Times, true, 2, f0.size());
                            return F.Times((IExpr)F.Plus(f0.arg1(), f13.arg1()), (IExpr)result);
                        }
                    } else if (f0.equalsFromPosition(1, f13, 0)) {
                        IAST result = F.ast(f0, F.Times, true, 2, f0.size());
                        return F.Times((IExpr)F.Plus((IExpr)F.C1, f0.arg1()), (IExpr)result);
                    }
                }
            } else if (o1.isTimes() && (f12 = (AST)o1).arg1().isNumber() && f0.equalsFromPosition(0, f12, 1)) {
                IAST result = F.ast(f12, F.Times, true, 2, f12.size());
                return F.Times((IExpr)F.Plus((IExpr)F.C1, f12.arg1()), (IExpr)result);
            }
        }
        if (o1.isTimes() && ((IAST)o1).arg1().isNumber() && (f1 = (IAST)o1).size() == 3 && f1.arg2().equals(o0)) {
            return F.Times((IExpr)F.Plus((IExpr)F.C1, f1.arg1()), o0);
        }
        return null;
    }

    private IExpr eInfinity(IExpr inf, IExpr o1) {
        EvalEngine engine = EvalEngine.get();
        if (inf.isInfinity()) {
            if (o1.isInfinity()) {
                return F.CInfinity;
            }
            if (o1.isNegativeInfinity()) {
                if (!engine.isQuietMode()) {
                    engine.getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
                }
                return F.Indeterminate;
            }
            if (o1.isSignedNumber()) {
                return F.CInfinity;
            }
        } else if (inf.isNegativeInfinity()) {
            if (o1.isInfinity()) {
                if (!engine.isQuietMode()) {
                    engine.getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
                }
                return F.Indeterminate;
            }
            if (o1.isNegativeInfinity()) {
                return F.CNInfinity;
            }
            if (o1.isSignedNumber()) {
                return F.CNInfinity;
            }
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        return c0.add(F.complex(i1, F.C0));
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1165);
        ORDERLESS_MATCHER.setUpHashRule(F.Power((IExpr)F.Sin(F.$p(F.x)), F.C2), F.Power((IExpr)F.Cos(F.$p(F.x)), F.C2), F.C1);
        ORDERLESS_MATCHER.setUpHashRule(F.Times((IExpr)F.$p(F.a), (IExpr)F.Power((IExpr)F.Sin(F.$p(F.x)), F.C2)), F.Times((IExpr)F.$p(F.a), (IExpr)F.Power((IExpr)F.Cos(F.$p(F.x)), F.C2)), F.a);
        ORDERLESS_MATCHER.setUpHashRule(F.ArcSin(F.$p(F.x)), F.ArcCos(F.$p(F.x)), F.Times((IExpr)F.C1D2, (IExpr)F.Pi));
        ORDERLESS_MATCHER.setUpHashRule(F.ArcTan(F.$p(F.x)), F.ArcCot(F.$p(F.x)), F.Times((IExpr)F.C1D2, (IExpr)F.Pi));
        ORDERLESS_MATCHER.setUpHashRule(F.ArcTan(F.$p(F.x)), F.ArcTan(F.$p(F.y)), F.Times((IExpr)F.C1D2, (IExpr)F.Pi), F.And(F.Positive(F.x), F.Equal((IExpr)F.y, (IExpr)F.Power((IExpr)F.x, F.CN1))));
        ORDERLESS_MATCHER.setUpHashRule(F.Times((IExpr)F.CN1, (IExpr)F.ArcTan(F.$p(F.x))), F.Times((IExpr)F.CN1, (IExpr)F.ArcTan(F.$p(F.y))), F.Times((IExpr)F.CN1D2, (IExpr)F.Pi), F.And(F.Positive(F.x), F.Equal((IExpr)F.y, (IExpr)F.Power((IExpr)F.x, F.CN1))));
        ORDERLESS_MATCHER.setUpHashRule(F.Power((IExpr)F.Cosh(F.$p(F.x)), F.C2), F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Sinh(F.$p(F.x)), F.C2)), F.C1);
        super.setUp(symbol);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        double result = 0.0;
        for (int i = top - size + 1; i < top + 1; ++i) {
            result += stack[i];
        }
        return result;
    }
}

