/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.linear.RealMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class InterpolatingFunction
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.head().isAST()) {
            IAST function = (IAST)ast.head();
            if (ast.size() == 2 && ast.arg1() instanceof INum) {
                int[] dims;
                if (function.size() == 2 && (dims = function.arg1().isMatrix()) != null && dims[1] == 2) {
                    RealMatrix matrix = Convert.list2RealMatrix((IAST)function.arg1());
                    double interpolatedY = this.interpolate(matrix, ((INum)ast.arg1()).doubleValue());
                    return F.num(interpolatedY);
                }
                return null;
            }
        }
        return null;
    }

    private double interpolate(RealMatrix matrix, double interpolationX) {
        int rowDim = matrix.getRowDimension();
        double[] x = new double[rowDim];
        double[] y = new double[rowDim];
        double[][] data = matrix.getData();
        for (int i = 0; i < rowDim; ++i) {
            x[i] = data[i][0];
            y[i] = data[i][1];
        }
        SplineInterpolator interpolator = new SplineInterpolator();
        UnivariateFunction function = interpolator.interpolate(x, y);
        double interpolatedY = function.value(interpolationX);
        return interpolatedY;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

