/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.IndexFunctionDiagonal;
import org.matheclipse.core.eval.util.IndexTableGenerator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class IdentityMatrix
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        if (ast.arg1().isInteger()) {
            int indx = Validate.checkIntType(ast, 1);
            IExpr[] valueArray = new IExpr[]{F.C0, F.C1};
            return IdentityMatrix.diagonalMatrix(valueArray, indx);
        }
        return null;
    }

    public static IAST diagonalMatrix(IExpr[] valueArray, int dimension) {
        IAST resultList = F.List();
        int[] indexArray = new int[]{dimension, dimension};
        IndexTableGenerator generator = new IndexTableGenerator(indexArray, resultList, new IndexFunctionDiagonal(valueArray));
        IAST matrix = (IAST)generator.table();
        if (matrix != null) {
            matrix.addEvalFlags(32);
        }
        return matrix;
    }
}

