/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.List;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.generic.PositionConverter;
import org.matheclipse.core.generic.interfaces.IPositionConverter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class Extract
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        if (ast.arg1().isAST() && ast.arg2().isAST()) {
            return Extract.extract((IAST)ast.arg1(), (IAST)ast.arg2());
        }
        return null;
    }

    public static IExpr extract(IAST list, IAST position) {
        PositionConverter converter = new PositionConverter();
        if (position.size() > 1 && position.arg1() instanceof IInteger) {
            return Extract.extract(list, position, converter, 1);
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(16384);
    }

    public static IExpr extract(IAST list, List<? extends IExpr> positions, IPositionConverter<? super IExpr> positionConverter, int headOffset) {
        int p = 0;
        IAST temp = list;
        int posSize = positions.size() - 1;
        IExpr expr = list;
        for (int i = headOffset; i <= posSize; ++i) {
            p = positionConverter.toInt(positions.get(i));
            if (temp == null || temp.size() <= p) {
                return null;
            }
            expr = (IExpr)temp.get(p);
            if (expr.isAST()) {
                temp = (IAST)expr;
                continue;
            }
            if (i >= positions.size()) continue;
            temp = null;
        }
        return expr;
    }
}

