/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.InverseFunction;
import org.matheclipse.core.visit.AbstractVisitorBoolean;

public class Eliminate
extends AbstractFunctionEvaluator {
    private static IAST checkEquations(IAST ast, int position) {
        IAST equalList = F.List();
        IAST eqns = null;
        if (((IExpr)ast.get(position)).isList()) {
            eqns = (IAST)ast.get(position);
            for (int i = 1; i < eqns.size(); ++i) {
                if (!((IExpr)eqns.get(i)).isAST(F.Equal, 3)) {
                    throw new WrongArgumentType(eqns, (IExpr)eqns.get(i), i, "Equal[] expression (a==b) expected");
                }
                IAST eq = (IAST)eqns.get(i);
                equalList.add(F.Equal(F.evalExpandAll(eq.arg1()), F.evalExpandAll(eq.arg2())));
            }
        } else if (((IExpr)ast.get(position)).isAST(F.Equal, 3)) {
            IAST eq = (IAST)ast.get(position);
            equalList.add(F.Equal(F.evalExpandAll(eq.arg1()), F.evalExpandAll(eq.arg2())));
        } else {
            throw new WrongArgumentType(ast, ast.arg1(), 1, "Equal[] expression (a==b) expected");
        }
        return equalList;
    }

    private static IExpr eliminateAnalyze(IAST equalAST, ISymbol variable) {
        IExpr arg1 = equalAST.arg1();
        IExpr arg2 = equalAST.arg2();
        Predicate<IExpr> predicate = Predicates.in(variable);
        boolean boolArg1 = arg1.isFree(predicate, true);
        boolean boolArg2 = arg2.isFree(predicate, true);
        IExpr result = null;
        if (!boolArg1 && boolArg2) {
            result = Eliminate.extractVariable(arg1, arg2, predicate, variable);
        } else if (boolArg1 && !boolArg2) {
            result = Eliminate.extractVariable(arg2, arg1, predicate, variable);
        }
        return result;
    }

    public static IExpr extractVariable(IExpr exprWithVariable, IExpr exprWithoutVariable, Predicate<IExpr> predicate, ISymbol variable) {
        if (exprWithVariable.isAST()) {
            IAST ast = (IAST)exprWithVariable;
            if (ast.size() == 2) {
                IAST inverseFunction = InverseFunction.getInverseFunction(ast);
                if (inverseFunction != null) {
                    inverseFunction.add(exprWithoutVariable);
                    return Eliminate.extractVariable(ast.arg1(), inverseFunction, predicate, variable);
                }
            } else {
                if (ast.isPlus()) {
                    IAST rest = F.Plus();
                    IAST plusClone = ast.clone();
                    int j = 1;
                    for (int i = 1; i < ast.size(); ++i) {
                        if (((IExpr)ast.get(i)).isFree(predicate, true)) {
                            ++j;
                            continue;
                        }
                        rest.add(ast.get(i));
                        plusClone.remove(j);
                    }
                    if (plusClone.size() == 1) {
                        return null;
                    }
                    IAST value = F.Subtract(exprWithoutVariable, plusClone);
                    return Eliminate.extractVariable(rest.getOneIdentity(F.C0), value, predicate, variable);
                }
                if (ast.isTimes()) {
                    IAST rest = F.Times();
                    IAST timesClone = ast.clone();
                    int j = 1;
                    for (int i = 1; i < ast.size(); ++i) {
                        if (((IExpr)ast.get(i)).isFree(predicate, true)) {
                            ++j;
                            continue;
                        }
                        rest.add(ast.get(i));
                        timesClone.remove(j);
                    }
                    if (timesClone.size() == 1) {
                        return null;
                    }
                    IAST value = F.Divide(exprWithoutVariable, timesClone);
                    return Eliminate.extractVariable(rest.getOneIdentity(F.C1), value, predicate, variable);
                }
                if (ast.isPower()) {
                    if (ast.arg2().isFree(predicate, true)) {
                        IAST value = F.Power(exprWithoutVariable, F.Divide(F.C1, ast.arg2()));
                        return Eliminate.extractVariable(ast.arg1(), value, predicate, variable);
                    }
                    if (ast.arg1().isFree(predicate, true)) {
                        IAST value = F.Divide(F.Log(exprWithoutVariable), F.Log(ast.arg1()));
                        return Eliminate.extractVariable(ast.arg2(), value, predicate, variable);
                    }
                }
            }
        } else if (exprWithVariable.equals(variable)) {
            return exprWithoutVariable;
        }
        return null;
    }

    public IAST eliminateOneVariable(ArrayList<VariableCounterVisitor> analyzerList, ISymbol variable) {
        IAST termsEqualZeroList = F.List();
        for (int i = 0; i < analyzerList.size(); ++i) {
            VariableCounterVisitor exprAnalyzer = analyzerList.get(i);
            IAST equalAST = exprAnalyzer.getExpr();
            IExpr variableExpr = Eliminate.eliminateAnalyze(equalAST, variable);
            if (variableExpr == null) continue;
            variableExpr = F.eval(variableExpr);
            IAST rule = F.Rule(variable, variableExpr);
            analyzerList.remove(i);
            for (int j = 0; j < analyzerList.size(); ++j) {
                IAST expr = analyzerList.get(j).getExpr();
                IExpr temp = expr.replaceAll(rule);
                if (temp != null) {
                    temp = F.evalExpandAll(temp);
                    termsEqualZeroList.add(temp);
                    continue;
                }
                termsEqualZeroList.add(expr);
            }
            return termsEqualZeroList;
        }
        return null;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        try {
            IAST termsEqualZeroList;
            IAST vars = Validate.checkSymbolOrSymbolList(ast, 2);
            IAST result = termsEqualZeroList = Eliminate.checkEquations(ast, 1);
            for (int i = 1; i < vars.size(); ++i) {
                ISymbol variable = (ISymbol)vars.get(i);
                ArrayList<VariableCounterVisitor> analyzerList = new ArrayList<VariableCounterVisitor>();
                for (int j = 1; j < result.size(); ++j) {
                    IAST equalAST = result.getAST(j);
                    VariableCounterVisitor exprAnalyzer = new VariableCounterVisitor(equalAST, variable);
                    equalAST.accept(exprAnalyzer);
                    analyzerList.add(exprAnalyzer);
                }
                Collections.sort(analyzerList);
                IAST temp = this.eliminateOneVariable(analyzerList, variable);
                if (temp == null) {
                    return result;
                }
                result = temp;
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static class VariableCounterVisitor
    extends AbstractVisitorBoolean
    implements Comparable<VariableCounterVisitor> {
        int fVariableCounter;
        int fNodeCounter;
        int fMaxVariableDepth;
        int fCurrentDepth;
        final IExpr fVariable;
        final IAST fExpr;

        public VariableCounterVisitor(IAST expr, IExpr variable) {
            this.fVariable = variable;
            this.fExpr = expr;
            this.fVariableCounter = 0;
            this.fNodeCounter = 0;
            this.fMaxVariableDepth = 0;
            this.fCurrentDepth = 0;
        }

        @Override
        public int compareTo(VariableCounterVisitor other) {
            if (this.fVariableCounter < other.fVariableCounter) {
                return -1;
            }
            if (this.fVariableCounter > other.fVariableCounter) {
                return 1;
            }
            if (this.fMaxVariableDepth < other.fMaxVariableDepth) {
                return -1;
            }
            if (this.fMaxVariableDepth > other.fMaxVariableDepth) {
                return 1;
            }
            if (this.fNodeCounter < other.fNodeCounter) {
                return -1;
            }
            if (this.fNodeCounter > other.fNodeCounter) {
                return 1;
            }
            return 0;
        }

        public IAST getExpr() {
            return this.fExpr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean visit(IAST ast) {
            ++this.fNodeCounter;
            if (ast.equals(this.fVariable)) {
                ++this.fVariableCounter;
                if (this.fMaxVariableDepth < this.fCurrentDepth) {
                    this.fMaxVariableDepth = this.fCurrentDepth;
                }
                return true;
            }
            try {
                ++this.fCurrentDepth;
                for (int i = 1; i < ast.size(); ++i) {
                    ((IExpr)ast.get(i)).accept(this);
                }
            }
            finally {
                --this.fCurrentDepth;
            }
            return false;
        }

        @Override
        public boolean visit(ISymbol symbol) {
            ++this.fNodeCounter;
            if (symbol.equals(this.fVariable)) {
                ++this.fVariableCounter;
                if (this.fMaxVariableDepth < this.fCurrentDepth) {
                    this.fMaxVariableDepth = this.fCurrentDepth;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(IInteger element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IFraction element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IComplex element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(INum element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IComplexNum element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IPattern element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IPatternSequence element) {
            ++this.fNodeCounter;
            return false;
        }

        @Override
        public boolean visit(IStringX element) {
            ++this.fNodeCounter;
            return false;
        }
    }
}

