/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.matheclipse.core.eval.exception.WrappedException;
import org.matheclipse.core.eval.interfaces.AbstractMatrix1Expr;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Eigenvalues
extends AbstractMatrix1Expr {
    @Override
    public IExpr evaluate(IAST ast) {
        return this.numericEval(ast);
    }

    @Override
    public IAST realMatrixEval(RealMatrix matrix) {
        try {
            IAST list = F.List();
            EigenDecomposition ed = new EigenDecomposition(matrix);
            double[] realValues = ed.getRealEigenvalues();
            double[] imagValues = ed.getImagEigenvalues();
            for (int i = 0; i < realValues.length; ++i) {
                if (F.isZero(imagValues[i])) {
                    list.add(F.num(realValues[i]));
                    continue;
                }
                list.add(F.complexNum(realValues[i], imagValues[i]));
            }
            return list;
        }
        catch (Exception ime) {
            throw new WrappedException(ime);
        }
    }

    @Override
    public ExprFieldElement matrixEval(FieldMatrix<ExprFieldElement> matrix) {
        return null;
    }
}

