/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;

public class ContinuedFraction
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IExpr num;
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = ast.arg1();
        int maxIterations = Integer.MAX_VALUE;
        if (ast.size() == 3 && ast.arg2().isInteger()) {
            maxIterations = Validate.checkIntType(ast, 2);
        }
        if (arg1 instanceof INum) {
            arg1 = F.fraction(((INum)arg1).getRealPart());
        } else if ((arg1.isAST() || arg1.isSymbol() && arg1.isNumericFunction()) && (num = F.evaln(arg1)) instanceof INum) {
            arg1 = F.fraction(((INum)num).getRealPart());
        }
        if (arg1.isRational()) {
            IRational rat = (IRational)arg1;
            IAST continuedFractionList = F.List();
            if (rat.getDenominator().equals(F.C1)) {
                continuedFractionList.add(rat.getNumerator());
            } else if (rat.getNumerator().equals(F.C1)) {
                continuedFractionList.add(F.C0);
                continuedFractionList.add(rat.getDenominator());
            } else {
                IFraction temp = F.fraction(rat.getNumerator(), rat.getDenominator());
                while (temp.getDenominator().isGreaterThan(F.C1) && 0 < maxIterations--) {
                    BigInteger quotient = temp.getBigNumerator().divide(temp.getBigDenominator());
                    BigInteger remainder = temp.getBigNumerator().mod(temp.getBigDenominator());
                    continuedFractionList.add(F.integer(quotient));
                    if (!(temp = F.fraction(temp.getBigDenominator(), remainder)).getDenominator().equals(F.C1)) continue;
                    continuedFractionList.add(temp.getNumerator());
                }
            }
            return continuedFractionList;
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(16384);
    }
}

