/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Conjugate
implements IFunctionEvaluator,
INumeric {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        if (arg1.isSignedNumber()) {
            return arg1;
        }
        if (arg1.isComplex()) {
            return ((IComplex)arg1).conjugate();
        }
        if (arg1 instanceof IComplexNum) {
            return ((IComplexNum)arg1).conjugate();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return stack[top];
    }
}

