/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class Complex
extends AbstractFunctionEvaluator {
    public static final Complex CONST = new Complex();

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        try {
            EvalEngine engine = EvalEngine.get();
            IExpr arg1 = ast.arg1();
            arg1 = engine.evaluate(arg1);
            IExpr arg2 = ast.arg2();
            arg2 = engine.evaluate(arg2);
            if (arg2.isComplex()) {
                if (((IComplex)arg2).getRealPart().equals((Object)BigFraction.ZERO)) {
                    arg2 = F.fraction(((IComplex)arg2).getImaginaryPart());
                }
            } else if (arg2.isComplexNumeric() && F.isZero(((IComplexNum)arg2).getRealPart())) {
                arg2 = F.num(((IComplexNum)arg2).getImaginaryPart());
            }
            if (arg1.isRational() && arg2.isRational()) {
                IFraction re = arg1.isInteger() ? F.fraction((IInteger)arg1, F.C1) : (IFraction)arg1;
                IFraction im = arg2.isInteger() ? F.fraction((IInteger)arg2, F.C1) : (IFraction)arg2;
                return F.complex(re, im);
            }
            if (arg1 instanceof INum && arg2 instanceof INum) {
                return F.complexNum(((INum)arg1).doubleValue(), ((INum)arg2).doubleValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

