/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Arg
extends AbstractTrigArg1
implements INumeric {
    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        ISymbol sym;
        IEvaluator eval;
        if (arg1.isSignedNumber()) {
            ISignedNumber in = (ISignedNumber)arg1;
            if (in.isNegative()) {
                return F.Pi;
            }
            if (!in.equals(F.C0)) {
                return F.C0;
            }
        } else {
            if (arg1.isComplexNumeric()) {
                IComplexNum ic = (IComplexNum)arg1;
                return F.num(Math.atan2(ic.getImaginaryPart(), ic.getRealPart()));
            }
            if (arg1.isComplex()) {
                IComplex ic = (IComplex)arg1;
                BigFraction x = ic.getRealPart();
                BigFraction y = ic.getImaginaryPart();
                int xi = x.compareTo(BigFraction.ZERO);
                int yi = y.compareTo(BigFraction.ZERO);
                if (xi < 0) {
                    if (yi < 0) {
                        return F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Pi), (IExpr)F.ArcTan(F.Divide(F.fraction(y), F.fraction(x))));
                    }
                    return F.Plus((IExpr)F.Pi, (IExpr)F.ArcTan(F.Divide(F.fraction(y), F.fraction(x))));
                }
                if (xi > 0) {
                    return F.ArcTan(F.Divide(F.fraction(y), F.fraction(x)));
                }
                if (yi < 0) {
                    return F.Plus((IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.Pi), (IExpr)F.ArcTan(F.Divide(F.fraction(x), F.fraction(y))));
                }
                if (yi > 0) {
                    return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Pi), (IExpr)F.ArcTan(F.Divide(F.fraction(x), F.fraction(y))));
                }
            }
        }
        if (arg1.isConstant() && (eval = (sym = (ISymbol)arg1).getEvaluator()) instanceof ISignedNumberConstant) {
            double val = ((ISignedNumberConstant)((Object)eval)).evalReal();
            if (val < 0.0) {
                return F.Pi;
            }
            if (val > 0.0) {
                return F.C0;
            }
        }
        return null;
    }

    @Override
    public IExpr numericEvalD1(Num arg1) {
        double d = arg1.getRealPart();
        if (d < 0.0) {
            return F.num(Math.PI);
        }
        if (d > 0.0) {
            return F.CD0;
        }
        return null;
    }

    @Override
    public IExpr numericEvalDC1(ComplexNum arg1) {
        return F.num(Math.atan2(arg1.getImaginaryPart(), arg1.getRealPart()));
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        if (stack[top] < 0.0) {
            return Math.PI;
        }
        if (stack[top] > 0.0) {
            return 0.0;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

