/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.IPartialFractionGenerator;
import org.matheclipse.core.polynomials.PartialFractionGenerator;
import org.matheclipse.core.reflection.system.Denominator;

public class Apart
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IAST variableList = null;
        if (ast.size() == 3) {
            variableList = Validate.checkSymbolOrSymbolList(ast, 2);
        } else {
            ExprVariables eVar = new ExprVariables(ast.arg1());
            if (!eVar.isSize(1)) {
                return null;
            }
            variableList = eVar.getVarList();
        }
        IExpr arg = ast.arg1();
        if (arg.isTimes() || arg.isPower()) {
            IAST plusResult;
            IExpr[] parts = Apart.getFractionalParts(ast.arg1());
            if (parts != null && (plusResult = Apart.partialFractionDecompositionRational(new PartialFractionGenerator(), parts, (ISymbol)variableList.arg1())) != null) {
                return plusResult.getOneIdentity(F.C0);
            }
        } else {
            return ast.arg1();
        }
        return null;
    }

    public static IAST partialFractionDecompositionInteger(IExpr[] parts, IAST variableList) {
        try {
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            ASTRange r = new ASTRange(variableList, 1);
            List<IExpr> varList = r.toList();
            String[] varListStr = new String[]{variableList.arg1().toString()};
            JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigInteger.ZERO);
            GenPolynomial numerator = jas.expr2JAS(exprNumerator);
            GenPolynomial denominator = jas.expr2JAS(exprDenominator);
            FactorAbstract factorAbstract = FactorFactory.getImplementation((BigInteger)BigInteger.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList D2 = new ArrayList(sfactors.keySet());
            SquarefreeAbstract sqf = SquarefreeFactory.getImplementation((BigInteger)BigInteger.ZERO);
            List Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                IExpr temp;
                IAST result = F.Plus();
                if (!((GenPolynomial)((List)Ai.get(0)).get(0)).isZERO()) {
                    temp = F.eval(jas.integerPoly2Expr((GenPolynomial<BigInteger>)((GenPolynomial)((List)Ai.get(0)).get(0))));
                    if (temp.isAST()) {
                        ((IAST)temp).addEvalFlags(128);
                    }
                    result.add(temp);
                }
                for (int i = 1; i < Ai.size(); ++i) {
                    List list = (List)Ai.get(i);
                    long j = 0L;
                    for (GenPolynomial genPolynomial : list) {
                        if (!genPolynomial.isZERO() && !(temp = F.eval(F.Times(jas.integerPoly2Expr((GenPolynomial<BigInteger>)genPolynomial), (IExpr)F.Power(jas.integerPoly2Expr((GenPolynomial<BigInteger>)((GenPolynomial)D2.get(i - 1))), F.integer(j * -1L))))).equals(F.C0)) {
                            if (temp.isAST()) {
                                ((IAST)temp).addEvalFlags(128);
                            }
                            result.add(temp);
                        }
                        ++j;
                    }
                }
                return result;
            }
        }
        catch (JASConversionException jASConversionException) {
            // empty catch block
        }
        return null;
    }

    public static IAST partialFractionDecompositionRational(IPartialFractionGenerator pf, IExpr[] parts, ISymbol x) {
        try {
            IAST variableList = F.List((IExpr)x);
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            ASTRange r = new ASTRange(variableList, 1);
            List<IExpr> varList = r.toList();
            String[] varListStr = new String[]{variableList.arg1().toString()};
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, (RingFactory<BigRational>)BigRational.ZERO);
            GenPolynomial numerator = jas.expr2JAS(exprNumerator);
            GenPolynomial denominator = jas.expr2JAS(exprDenominator);
            FactorAbstract factorAbstract = FactorFactory.getImplementation((BigRational)BigRational.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList D2 = new ArrayList(sfactors.keySet());
            SquarefreeAbstract sqf = SquarefreeFactory.getImplementation((BigRational)BigRational.ZERO);
            List Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                pf.setJAS(jas);
                if (!((GenPolynomial)((List)Ai.get(0)).get(0)).isZERO()) {
                    pf.addNonFractionalPart((GenPolynomial<BigRational>)((GenPolynomial)((List)Ai.get(0)).get(0)));
                }
                for (int i = 1; i < Ai.size(); ++i) {
                    List list = (List)Ai.get(i);
                    int j = 0;
                    for (GenPolynomial genPolynomial : list) {
                        if (!genPolynomial.isZERO()) {
                            GenPolynomial Di_1 = (GenPolynomial)D2.get(i - 1);
                            pf.addSinglePartialFraction((GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)Di_1, j);
                        }
                        ++j;
                    }
                }
                return pf.getResult();
            }
        }
        catch (JASConversionException jASConversionException) {
            // empty catch block
        }
        return null;
    }

    public static IExpr[] getFractionalParts(IExpr arg) {
        IExpr[] parts = null;
        if (arg.isTimes()) {
            parts = Apart.getFractionalPartsTimes((IAST)arg, true);
        } else if (arg.isPower()) {
            IAST temp = (IAST)arg;
            if (temp.arg2().isSignedNumber()) {
                ISignedNumber sn = (ISignedNumber)temp.arg2();
                parts = new IExpr[2];
                if (sn.equals(F.CN1)) {
                    parts[0] = F.C1;
                    parts[1] = temp.arg1();
                } else if (sn.isNegative()) {
                    parts[0] = F.C1;
                    parts[1] = F.Power(temp.arg1(), sn.negate());
                } else {
                    IAST function;
                    IAST denomForm;
                    if (sn.isInteger() && temp.arg1().isAST() && (denomForm = Denominator.getDenominatorForm(function = (IAST)temp.arg1())) != null) {
                        parts[0] = F.C1;
                        parts[1] = F.Power((IExpr)denomForm, sn);
                        return parts;
                    }
                    parts[0] = arg;
                    parts[1] = F.C1;
                }
            }
        } else {
            IAST denomForm;
            if (arg.isAST() && (denomForm = Denominator.getDenominatorForm((IAST)arg)) != null) {
                parts = new IExpr[]{F.C1, denomForm};
                return parts;
            }
            parts = new IExpr[]{arg, F.C1};
        }
        return parts;
    }

    public static IExpr[] getFractionalPartsTimes(IAST ast, boolean splitFractionalNumbers) {
        IExpr[] result = new IExpr[2];
        IAST numerator = F.Times();
        IAST denominator = F.Times();
        for (int i = 1; i < ast.size(); ++i) {
            IExpr arg;
            block9: {
                block7: {
                    IAST function;
                    IAST denomForm;
                    IAST argAST;
                    block8: {
                        arg = (IExpr)ast.get(i);
                        if (!arg.isAST()) break block7;
                        argAST = (IAST)arg;
                        if (argAST.size() != 2) break block8;
                        IAST denomForm2 = Denominator.getDenominatorForm(argAST);
                        if (denomForm2 != null) {
                            denominator.add(denomForm2);
                            continue;
                        }
                        break block9;
                    }
                    if (!arg.isPower() || !argAST.arg2().isSignedNumber()) break block9;
                    ISignedNumber sn = (ISignedNumber)argAST.arg2();
                    if (sn.equals(F.CN1)) {
                        denominator.add(argAST.arg1());
                        continue;
                    }
                    if (sn.isNegative()) {
                        denominator.add(F.Power(argAST.arg1(), ((ISignedNumber)argAST.arg2()).negate()));
                        continue;
                    }
                    if (sn.isInteger() && argAST.arg1().isAST() && (denomForm = Denominator.getDenominatorForm(function = (IAST)argAST.arg1())) != null) {
                        denominator.add(F.Power((IExpr)denomForm, sn));
                        continue;
                    }
                    break block9;
                }
                if (splitFractionalNumbers && arg.isRational()) {
                    IInteger denom;
                    IInteger numer = ((IRational)arg).getNumerator();
                    if (!numer.equals(F.C1)) {
                        numerator.add(numer);
                    }
                    if ((denom = ((IRational)arg).getDenominator()).equals(F.C1)) continue;
                    denominator.add(denom);
                    continue;
                }
            }
            numerator.add(arg);
        }
        result[0] = numerator.getOneIdentity(F.C1);
        result[1] = denominator.getOneIdentity(F.C1);
        return result;
    }
}

