/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class AddTo
extends AbstractFunctionEvaluator {
    protected Function<IExpr, IExpr> getFunction(IExpr value) {
        return new AddToFunction(value);
    }

    protected ISymbol getFunctionSymbol() {
        return F.AddTo;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        ISymbol sym = Validate.checkSymbolType(ast, 1);
        IExpr arg2 = F.eval(ast.arg2());
        IExpr[] results = sym.reassignSymbolValue(this.getFunction(F.eval(arg2)), this.getFunctionSymbol());
        if (results != null) {
            return results[1];
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    class AddToFunction
    implements Function<IExpr, IExpr> {
        final IExpr value;

        public AddToFunction(IExpr value) {
            this.value = value;
        }

        public IExpr apply(IExpr assignedValue) {
            return F.eval(F.Plus(assignedValue, this.value));
        }
    }
}

