/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.TreeSet;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class QuarticSolver {
    public static IAST solve(IExpr exprPoly, IExpr x) throws ArithmeticException {
        IExpr[] coefficients = new IExpr[]{F.C0, F.C0, F.C0, F.C0, F.C0};
        if (QuarticSolver.convert2Coefficients(exprPoly, x, coefficients)) {
            return QuarticSolver.quarticSolve(coefficients[4], coefficients[3], coefficients[2], coefficients[1], coefficients[0]);
        }
        return null;
    }

    private static boolean convert2Coefficients(IExpr exprPoly, IExpr x, IExpr[] coefficients) {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            if (ast.isPlus()) {
                for (int i = 1; i < ast.size(); ++i) {
                    if (QuarticSolver.convertTerm2Coefficients((IExpr)ast.get(i), x, coefficients)) continue;
                    return false;
                }
                return true;
            }
            if (QuarticSolver.convertTerm2Coefficients(ast, x, coefficients)) {
                return true;
            }
        } else if (QuarticSolver.convertTerm2Coefficients(exprPoly, x, coefficients)) {
            return true;
        }
        return false;
    }

    private static boolean convertTerm2Coefficients(IExpr exprPoly, IExpr x, IExpr[] coefficients) {
        if (exprPoly.isFree(x, true)) {
            coefficients[0] = F.eval(F.Plus(coefficients[0], exprPoly));
            return true;
        }
        if (exprPoly instanceof IAST) {
            IExpr temp;
            IAST ast = (IAST)exprPoly;
            if (ast.isTimes()) {
                int exponent = -1;
                IAST coeff = ast.clone();
                for (int i = 1; i < ast.size(); ++i) {
                    if (((IExpr)ast.get(i)).isPower()) {
                        IExpr temp2 = ((IExpr)ast.get(i)).getAt(1);
                        if (!x.equals(temp2)) continue;
                        try {
                            exponent = Validate.checkPowerExponent((IAST)ast.get(i));
                        }
                        catch (WrongArgumentType e) {
                            // empty catch block
                        }
                        if (exponent < 0 || exponent > 4) {
                            return false;
                        }
                        coeff.remove(i);
                        coefficients[exponent] = F.eval(F.Plus(coefficients[exponent], (IExpr)coeff));
                        return true;
                    }
                    if (!x.equals(ast.get(i))) continue;
                    coeff.remove(i);
                    coefficients[1] = F.eval(F.Plus(coefficients[1], (IExpr)coeff));
                    return true;
                }
                return true;
            }
            if (ast.isPower() && x.equals(temp = (IExpr)ast.get(1))) {
                int exponent = -1;
                try {
                    exponent = Validate.checkPowerExponent(ast);
                }
                catch (WrongArgumentType e) {
                    // empty catch block
                }
                if (exponent < 0 || exponent > 4) {
                    return false;
                }
                coefficients[exponent] = F.eval(F.Plus(coefficients[exponent], (IExpr)F.C1));
                return true;
            }
        } else if (exprPoly instanceof ISymbol && x.equals(exprPoly)) {
            coefficients[1] = F.eval(F.Plus(coefficients[1], (IExpr)F.C1));
            return true;
        }
        return false;
    }

    public static IAST quarticSolveN(IExpr a, IExpr b, IExpr c, IExpr d, IExpr e) {
        return (IAST)F.evaln(QuarticSolver.quarticSolve(a, b, c, d, e));
    }

    public static IAST quarticSolve(IExpr a, IExpr b, IExpr c, IExpr d, IExpr e) {
        if (a.isZero()) {
            return QuarticSolver.cubicSolve(b, c, d, e, null);
        }
        if (e.isZero()) {
            IAST result = QuarticSolver.cubicSolve(a, b, c, d, F.C0);
            return result;
        }
        if (b.isZero() && d.isZero()) {
            return QuarticSolver.biQuadraticSolve(a, c, e, null);
        }
        if (a.equals(e) && b.equals(d)) {
            return QuarticSolver.quasiSymmetricQuarticSolve(a, b, c);
        }
        IExpr alpha = F.eval(F.Plus((IExpr)F.Times(F.CN3, F.Power(b, F.C2), F.Power((IExpr)F.Times((IExpr)F.ZZ(8L), (IExpr)F.Power(a, F.C2)), F.CN1)), (IExpr)F.Times(c, (IExpr)F.Power(a, F.CN1))));
        IExpr beta = F.eval(F.Plus(F.Times((IExpr)F.Power(b, F.C3), (IExpr)F.Power((IExpr)F.Times((IExpr)F.ZZ(8L), (IExpr)F.Power(a, F.C3)), F.CN1)), F.Times(F.CN1, b, c, F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(d, (IExpr)F.Power(a, F.CN1))));
        IExpr gamma = F.eval(F.Plus(F.Times(F.CN3, F.Power(b, F.C4), F.Power((IExpr)F.Times((IExpr)F.ZZ(256L), (IExpr)F.Power(a, F.C4)), F.CN1)), F.Times(F.Power(b, F.C2), c, F.Power((IExpr)F.Times((IExpr)F.ZZ(16L), (IExpr)F.Power(a, F.C3)), F.CN1)), F.Times(F.CN1, b, d, F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(e, (IExpr)F.Power(a, F.CN1))));
        if (beta.isZero()) {
            return QuarticSolver.biQuadraticSolve(F.C1, alpha, gamma, F.Times(F.CN1D4, b, F.Power(a, F.CN1)));
        }
        IAST result = F.List();
        IExpr discriminant = F.eval(F.Plus(F.Times(F.integer(256L), F.Power(a, F.C3), F.Power(e, F.C3)), F.Times(F.CN1, F.integer(192L), F.Power(a, F.C2), b, d, F.Power(e, F.C2)), F.Times(F.CN1, F.integer(128L), F.Power(a, F.C2), F.Power(c, F.C2), F.Power(e, F.C2)), F.Times(F.integer(144L), F.Power(a, F.C2), c, F.Power(d, F.C2), e), F.Times(F.CN1, F.integer(27L), F.Power(a, F.C2), F.Power(d, F.C4)), F.Times(F.integer(144L), a, F.Power(b, F.C2), c, F.Power(e, F.C2)), F.Times(F.CN1, F.integer(6L), a, F.Power(b, F.C2), F.Power(d, F.C2), e), F.Times(F.CN1, F.integer(80L), a, b, F.Power(c, F.C2), d, e), F.Times(F.integer(18L), a, b, c, F.Power(d, F.C3)), F.Times(F.integer(16L), a, F.Power(c, F.C4), e), F.Times(F.CN1, F.C4, a, F.Power(c, F.C3), F.Power(d, F.C2)), F.Times(F.CN1, F.integer(27L), F.Power(b, F.C4), F.Power(e, F.C2)), F.Times(F.integer(18L), F.Power(b, F.C3), c, d, e), F.Times(F.CN1, F.C4, F.Power(b, F.C3), F.Power(d, F.C3)), F.Times(F.CN1, F.C4, F.Power(b, F.C2), F.Power(c, F.C3), e), F.Times(F.Power(b, F.C2), F.Power(c, F.C2), F.Power(d, F.C2))));
        IExpr dd = F.eval(F.Plus(F.Times(F.integer(64L), F.Power(a, F.C3), e), F.Times(F.CN1, F.integer(16L), F.Power(a, F.C2), F.Power(c, F.C2)), F.Times(F.integer(16L), a, F.Power(b, F.C2), c), F.Times(F.integer(16L), F.Power(a, F.C2), b, d), F.Times(F.CN1, F.C3, F.Power(b, F.C4))));
        IExpr delta0 = F.eval(F.Plus(F.Power(c, F.C2), F.Times(F.CN1, F.C3, b, d), F.Times(F.integer(12L), a, e)));
        IExpr delta1 = F.eval(F.Plus(F.Times((IExpr)F.C2, (IExpr)F.Power(c, F.C3)), F.Times(F.CN1, F.integer(9L), b, c, d), F.Times(F.integer(27L), a, F.Power(d, F.C2)), F.Times(F.integer(27L), F.Power(b, F.C2), e), F.Times(F.CN1, F.integer(72L), a, c, e)));
        IExpr delta3 = F.eval(F.Power((IExpr)F.Plus(delta1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power(delta1, F.C2), (IExpr)F.Times(F.CN1, F.C4, F.Power(delta0, F.C3))))), F.C1D3));
        result.add(F.Plus(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), F.Times(F.CN1, F.C1D2, F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.Times(F.CN1, F.C1D2, F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(F.CN1, delta3, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times(F.CN1, F.Plus(F.Times(F.CN1, F.Power(b, F.C3), F.Power((IExpr)F.Power(a, F.C3), F.CN1)), F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), F.Times(F.CN1, F.integer(8L), d, F.Power(a, F.CN1))), F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        result.add(F.Plus(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), F.Times(F.CN1, F.C1D2, F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(F.CN1, delta3, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times(F.CN1, F.Plus(F.Times(F.CN1, F.Power(b, F.C3), F.Power((IExpr)F.Power(a, F.C3), F.CN1)), F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), F.Times(F.CN1, F.integer(8L), d, F.Power(a, F.CN1))), F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        result.add(F.Plus(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.Times(F.CN1, F.C1D2, F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(F.CN1, delta3, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times((IExpr)F.Plus(F.Times(F.CN1, F.Power(b, F.C3), F.Power((IExpr)F.Power(a, F.C3), F.CN1)), F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), F.Times(F.CN1, F.integer(8L), d, F.Power(a, F.CN1))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        result.add(F.Plus(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C4, a), F.CN1)), F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C4, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(F.CN1, delta3, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1)), F.Times((IExpr)F.Plus(F.Times(F.CN1, F.Power(b, F.C3), F.Power((IExpr)F.Power(a, F.C3), F.CN1)), F.Times(F.C4, b, c, F.Power((IExpr)F.Power(a, F.C2), F.CN1)), F.Times(F.CN1, F.integer(8L), d, F.Power(a, F.CN1))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Plus(F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C4, (IExpr)F.Power(a, F.C2)), F.CN1)), F.Times(F.CN1, F.C2, c, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Power((IExpr)F.C2, F.C1D3), delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))))), F.CN1)))))));
        return QuarticSolver.createSet(result);
    }

    public static IAST depressedQuarticSolve(IExpr A, IExpr B, IExpr a, IExpr b, IExpr c) {
        IExpr y;
        IAST result = F.List();
        IExpr P = F.eval(F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.QQ(1L, 12L), (IExpr)F.Power(a, F.C2)), c)));
        IExpr Q = F.eval(F.Plus(F.Times((IExpr)F.QQ(-1L, 108L), (IExpr)F.Power(a, F.C3)), F.Times(F.C1D3, a, c), F.Times((IExpr)F.QQ(-1L, 8L), (IExpr)F.Power(b, F.C2))));
        if (P.isZero()) {
            y = F.eval(F.Plus((IExpr)F.Times((IExpr)F.QQ(-5L, 6L), a), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(Q, F.C1D3))));
        } else {
            IExpr U = F.eval(F.Power((IExpr)F.Plus((IExpr)F.Times(F.C1D2, F.CN1, Q), (IExpr)F.Sqrt(F.Plus((IExpr)F.Times((IExpr)F.C1D4, (IExpr)F.Power(Q, F.C2)), (IExpr)F.Times((IExpr)F.QQ(1L, 27L), (IExpr)F.Power(P, F.C3))))), F.C1D3));
            y = F.Plus(F.Times((IExpr)F.QQ(-5L, 6L), a), F.Times((IExpr)F.CN1, U), F.Times(F.CN1, P, F.Power((IExpr)F.Times((IExpr)F.C3, U), F.CN1)));
        }
        IAST w = F.Sqrt(F.Plus(a, (IExpr)F.Times((IExpr)F.C2, y)));
        result.add(F.Plus((IExpr)F.Times(F.CN1, B, F.Power((IExpr)F.Times((IExpr)F.C4, A), F.CN1)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)w, (IExpr)F.Sqrt(F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Plus(a, (IExpr)F.Times((IExpr)F.C2, y))), (IExpr)F.Times(F.CN1, F.C2, F.Plus(a, (IExpr)F.Times(b, (IExpr)F.Power((IExpr)w, F.CN1))))))))));
        result.add(F.Plus((IExpr)F.Times(F.CN1, B, F.Power((IExpr)F.Times((IExpr)F.C4, A), F.CN1)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)w, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Plus(a, (IExpr)F.Times((IExpr)F.C2, y))), (IExpr)F.Times(F.CN1, F.C2, F.Plus(a, (IExpr)F.Times(b, (IExpr)F.Power((IExpr)w, F.CN1)))))))))));
        result.add(F.Plus((IExpr)F.Times(F.CN1, B, F.Power((IExpr)F.Times((IExpr)F.C4, A), F.CN1)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)w), (IExpr)F.Sqrt(F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Plus(a, (IExpr)F.Times((IExpr)F.C2, y))), (IExpr)F.Times(F.CN1, F.C2, F.Plus(a, (IExpr)F.Times(F.CN1, b, F.Power((IExpr)w, F.CN1))))))))));
        result.add(F.Plus((IExpr)F.Times(F.CN1, B, F.Power((IExpr)F.Times((IExpr)F.C4, A), F.CN1)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)w), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Plus(a, (IExpr)F.Times((IExpr)F.C2, y))), (IExpr)F.Times(F.CN1, F.C2, F.Plus(a, (IExpr)F.Times(F.CN1, b, F.Power((IExpr)w, F.CN1)))))))))));
        return QuarticSolver.createSet(result);
    }

    public static IAST cubicSolve(IExpr a, IExpr b, IExpr c, IExpr d, IExpr additionalSulution) {
        if (a.isZero()) {
            return QuarticSolver.quadraticSolve(b, c, d, additionalSulution, null);
        }
        if (d.isZero()) {
            return QuarticSolver.quadraticSolve(a, b, c, additionalSulution, F.C0);
        }
        IAST result = F.List();
        if (additionalSulution != null) {
            result.add(additionalSulution);
        }
        IExpr discriminant = F.eval(F.Plus(F.Times(F.integer(18L), a, b, c, d), F.Times(F.CN1, F.C4, F.Power(b, F.C3), d), F.Times((IExpr)F.Power(b, F.C2), (IExpr)F.Power(c, F.C2)), F.Times(F.CN1, F.C4, a, F.Power(c, F.C3)), F.Times(F.CN1, F.integer(27L), F.Power(a, F.C2), F.Power(d, F.C2))));
        IExpr delta0 = F.eval(F.Plus((IExpr)F.Power(b, F.C2), (IExpr)F.Times(F.CN1, F.C3, a, c)));
        IExpr delta1 = F.eval(F.Plus(F.Times((IExpr)F.integer(-2L), (IExpr)F.Power(b, F.C3)), F.Times(F.integer(9L), a, b, c), F.Times(F.CN1, F.integer(27L), F.Power(a, F.C2), d)));
        IExpr delta3 = F.eval(F.Power((IExpr)F.Plus(delta1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power(delta1, F.C2), (IExpr)F.Times(F.CN1, F.C4, F.Power(delta0, F.C3))))), F.C1D3));
        if (discriminant.isZero()) {
            if (delta0.isZero()) {
                result.add(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)));
            } else {
                result.add(F.Times((IExpr)F.Plus((IExpr)F.Times(F.integer(9L), a, d), (IExpr)F.Times(F.CN1, b, c)), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, delta0), F.CN1)));
                result.add(F.Times((IExpr)F.Plus(F.Times(F.C4, a, b, c), F.Times(F.CN1, F.integer(9L), F.Power(a, F.C2), d), F.Times((IExpr)F.CN1, (IExpr)F.Power(b, F.C3))), (IExpr)F.Power((IExpr)F.Times(a, delta0), F.CN1)));
            }
        } else {
            result.add(F.Plus(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.CN1, F.Power((IExpr)F.C2, F.C1D3), F.CN1, delta0, F.Power((IExpr)F.Times(F.C3, a, delta3), F.CN1)), F.Times(delta3, (IExpr)F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))));
            result.add(F.Plus(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sqrt(F.C3))), F.CN1, delta0, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.fraction(2L, 3L)), a, delta3), F.CN1)), F.Times(F.CN1, F.Plus((IExpr)F.C1, (IExpr)F.Times(F.CN1, F.CI, F.Sqrt(F.C3))), delta3, F.Power((IExpr)F.Times(F.integer(6L), F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))));
            result.add(F.Plus(F.Times(F.CN1, b, F.Power((IExpr)F.Times((IExpr)F.C3, a), F.CN1)), F.Times(F.Plus((IExpr)F.C1, (IExpr)F.Times(F.CN1, F.CI, F.Sqrt(F.C3))), F.CN1, delta0, F.Power((IExpr)F.Times(F.C3, F.Power((IExpr)F.C2, F.fraction(2L, 3L)), a, delta3), F.CN1)), F.Times(F.CN1, F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sqrt(F.C3))), delta3, F.Power((IExpr)F.Times(F.integer(6L), F.Power((IExpr)F.C2, F.C1D3), a), F.CN1))));
        }
        return QuarticSolver.createSet(result);
    }

    public static IAST createSet(IAST result) {
        TreeSet<IExpr> set1 = new TreeSet<IExpr>();
        for (int i = 1; i < result.size(); ++i) {
            IExpr temp = F.evalExpandAll((IExpr)result.get(i));
            if (temp.equals(F.Indeterminate)) continue;
            set1.add(temp);
        }
        result = F.List();
        for (IExpr e : set1) {
            result.add(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IAST quadraticSolve(IExpr a, IExpr b, IExpr c, IExpr solution1, IExpr solution2) {
        IAST result = F.List();
        if (solution1 != null) {
            result.add(solution1);
        }
        if (solution2 != null) {
            result.add(solution2);
        }
        if (a.isZero()) {
            if (b.isZero()) return QuarticSolver.createSet(result);
            result.add(F.Times(F.CN1, c, F.Power(b, F.CN1)));
            return QuarticSolver.createSet(result);
        }
        if (c.isZero()) {
            result.add(F.C0);
            if (b.isZero()) return QuarticSolver.createSet(result);
            result.add(F.Times(F.CN1, b, F.Power(a, F.CN1)));
            return QuarticSolver.createSet(result);
        }
        result.add(F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, b), (IExpr)F.Sqrt(F.Plus((IExpr)F.Power(b, F.C2), (IExpr)F.Times(F.CN1, F.C4, a, c)))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1)));
        result.add(F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, b), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power(b, F.C2), (IExpr)F.Times(F.CN1, F.C4, a, c))))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1)));
        return QuarticSolver.createSet(result);
    }

    public static IAST biQuadraticSolve(IExpr a, IExpr c, IExpr e, IExpr sum) {
        IAST result = F.List();
        IExpr sqrt = F.eval(F.Sqrt(F.Plus((IExpr)F.Power(c, F.C2), (IExpr)F.Times(F.CN1, F.C4, a, e))));
        IAST y1 = F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, c), sqrt), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        IAST y2 = F.Times(F.CN1, F.Plus(c, sqrt), F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        if (sum == null) {
            result.add(F.Sqrt(y1));
            result.add(F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y1)));
            result.add(F.Sqrt(y2));
            result.add(F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y2)));
        } else {
            result.add(F.Plus(sum, (IExpr)F.Sqrt(y1)));
            result.add(F.Plus(sum, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y1))));
            result.add(F.Plus(sum, (IExpr)F.Sqrt(y2)));
            result.add(F.Plus(sum, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(y2))));
        }
        return QuarticSolver.createSet(result);
    }

    public static IAST quasiSymmetricQuarticSolve(IExpr a, IExpr b, IExpr c) {
        IAST result = F.List();
        IExpr sqrt = F.eval(F.Sqrt(F.Plus(F.Power(b, F.C2), F.Times(F.CN1, F.C4, a, c), F.Times((IExpr)F.ZZ(8L), (IExpr)F.Power(a, F.C2)))));
        IAST y1 = F.Times((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, b), sqrt), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        IAST y2 = F.Times(F.CN1, F.Plus(b, sqrt), F.Power((IExpr)F.Times((IExpr)F.C2, a), F.CN1));
        result.add(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y1, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4))))));
        result.add(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y1, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4)))))));
        result.add(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y2, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y2, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4))))));
        result.add(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)y2, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(F.Plus((IExpr)F.Power((IExpr)y2, F.C2), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C4)))))));
        return QuarticSolver.createSet(result);
    }
}

