/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluationEngine;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.core.patternmatching.PatternMatcherEquals;

public class UpRulesData
implements Serializable {
    private static final long serialVersionUID = 779382003637253257L;
    private transient Map<IExpr, PatternMatcherEquals> fEqualUpRules = null;
    private transient ArrayListMultimap<Integer, IPatternMatcher> fSimplePatternUpRules = null;

    public void clear() {
        this.fEqualUpRules = null;
        this.fSimplePatternUpRules = null;
    }

    public IExpr evalUpRule(IEvaluationEngine ee, IExpr expression) {
        PatternMatcherEquals res;
        if (this.fEqualUpRules != null && (res = this.fEqualUpRules.get(expression)) != null) {
            return res.getRHS();
        }
        try {
            Integer hash;
            List list;
            if (this.fSimplePatternUpRules != null && expression.isAST() && (list = this.fSimplePatternUpRules.get((Object)(hash = Integer.valueOf(((IAST)expression).patternHashCode())))) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    IPatternMatcher pmEvaluator = (IPatternMatcher)((IPatternMatcher)list.get(i)).clone();
                    IExpr result = pmEvaluator.eval(expression);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return null;
    }

    public IPatternMatcher putUpRule(ISymbol setSymbol, boolean equalRule, IAST leftHandSide, IExpr rightHandSide, int priority) {
        if (equalRule) {
            this.fEqualUpRules = this.getEqualUpRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualUpRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        PatternMatcherAndEvaluator pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, leftHandSide, rightHandSide);
        if (pmEvaluator.isRuleWithoutPatterns()) {
            this.fEqualUpRules = this.getEqualUpRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualUpRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        this.fSimplePatternUpRules = this.getSimplePatternUpRules();
        return this.addSimplePatternUpRule(leftHandSide, pmEvaluator);
    }

    private PatternMatcher addSimplePatternUpRule(IExpr leftHandSide, PatternMatcher pmEvaluator) {
        Integer hash = ((IAST)leftHandSide).patternHashCode();
        if (F.isSystemInitialized && this.fSimplePatternUpRules.containsEntry((Object)hash, (Object)pmEvaluator)) {
            this.fSimplePatternUpRules.remove((Object)hash, (Object)pmEvaluator);
        }
        this.fSimplePatternUpRules.put((Object)hash, (Object)pmEvaluator);
        return pmEvaluator;
    }

    private boolean isComplicatedPatternRule(IExpr lhsExpr) {
        if (lhsExpr.isAST()) {
            IAST lhsAST = (IAST)lhsExpr;
            if (lhsAST.size() > 1) {
                int attr = lhsAST.topHead().getAttributes();
                if ((4 & attr) == 4) {
                    return true;
                }
                if (((IExpr)lhsAST.get(1)).isAST()) {
                    IAST arg1 = (IAST)lhsAST.get(1);
                    if (arg1.isCondition()) {
                        return true;
                    }
                    for (int i = 2; i < arg1.size(); ++i) {
                        if (!((IExpr)arg1.get(i)).isPattern() || !((IPattern)arg1.get(i)).isDefault()) continue;
                        return true;
                    }
                } else {
                    if (((IExpr)lhsAST.get(1)).isPattern()) {
                        return true;
                    }
                    if (((IExpr)lhsAST.get(1)).isPatternSequence()) {
                        return true;
                    }
                }
                for (int i = 2; i < lhsAST.size(); ++i) {
                    if (!((IExpr)lhsAST.get(i)).isPattern() || !((IPattern)lhsAST.get(i)).isDefault()) continue;
                    return true;
                }
            }
        } else {
            if (lhsExpr.isPattern()) {
                return true;
            }
            if (lhsExpr.isPatternSequence()) {
                return true;
            }
        }
        return false;
    }

    public Map<IExpr, PatternMatcherEquals> getEqualUpRules() {
        if (this.fEqualUpRules == null) {
            this.fEqualUpRules = new HashMap<IExpr, PatternMatcherEquals>();
        }
        return this.fEqualUpRules;
    }

    private ArrayListMultimap<Integer, IPatternMatcher> getSimplePatternUpRules() {
        if (this.fSimplePatternUpRules == null) {
            this.fSimplePatternUpRules = ArrayListMultimap.create();
        }
        return this.fSimplePatternUpRules;
    }

    public List<IAST> definition() {
        IAST ast;
        ISymbol setSymbol;
        ArrayList<IAST> definitionList = new ArrayList<IAST>();
        if (this.fEqualUpRules != null && this.fEqualUpRules.size() > 0) {
            for (IExpr key : this.fEqualUpRules.keySet()) {
                PatternMatcherEquals pme = this.fEqualUpRules.get(key);
                setSymbol = pme.getSetSymbol();
                ast = F.ast(setSymbol);
                ast.add(key);
                ast.add(pme.getRHS());
                definitionList.add(ast);
            }
        }
        if (this.fSimplePatternUpRules != null && this.fSimplePatternUpRules.size() > 0) {
            for (IPatternMatcher elem : this.fSimplePatternUpRules.values()) {
                if (!(elem instanceof PatternMatcherAndEvaluator)) continue;
                PatternMatcherAndEvaluator pmEvaluator = (PatternMatcherAndEvaluator)elem;
                setSymbol = pmEvaluator.getSetSymbol();
                ast = F.ast(setSymbol);
                ast.add(pmEvaluator.getLHS());
                IExpr condition = pmEvaluator.getCondition();
                if (condition != null) {
                    ast.add(F.Condition(pmEvaluator.getRHS(), condition));
                } else {
                    ast.add(pmEvaluator.getRHS());
                }
                definitionList.add(ast);
            }
        }
        return definitionList;
    }

    public void readSymbol(ObjectInputStream stream) throws IOException {
        ISymbol setSymbol;
        String astString;
        EvalEngine engine = EvalEngine.get();
        int len = stream.read();
        if (len > 0) {
            this.fEqualUpRules = new HashMap<IExpr, PatternMatcherEquals>();
            for (int i = 0; i < len; ++i) {
                astString = stream.readUTF();
                setSymbol = F.$s(astString);
                astString = stream.readUTF();
                IExpr key = engine.parse(astString);
                astString = stream.readUTF();
                IExpr value = engine.parse(astString);
                this.fEqualUpRules.put(key, new PatternMatcherEquals(setSymbol, key, value));
            }
        }
        if ((len = stream.read()) > 0) {
            this.fSimplePatternUpRules = ArrayListMultimap.create();
            for (int i = 0; i < len; ++i) {
                IExpr condition;
                astString = stream.readUTF();
                setSymbol = F.$s(astString);
                astString = stream.readUTF();
                IExpr lhs = engine.parse(astString);
                astString = stream.readUTF();
                IExpr rhs = engine.parse(astString);
                PatternMatcherAndEvaluator pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, lhs, rhs);
                int condLength = stream.read();
                if (condLength == 0) {
                    condition = null;
                } else {
                    astString = stream.readUTF();
                    condition = engine.parse(astString);
                    pmEvaluator.setCondition(condition);
                }
                this.addSimplePatternUpRule(lhs, pmEvaluator);
            }
        }
    }

    public void writeSymbol(ObjectOutputStream stream) throws IOException {
        if (this.fEqualUpRules == null || this.fEqualUpRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fEqualUpRules.size());
            for (IExpr key : this.fEqualUpRules.keySet()) {
                PatternMatcherEquals pme = this.fEqualUpRules.get(key);
                stream.writeUTF(pme.getLHS().toString());
                stream.writeUTF(key.fullFormString());
                stream.writeUTF(pme.getRHS().fullFormString());
            }
        }
        if (this.fSimplePatternUpRules == null || this.fSimplePatternUpRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fSimplePatternUpRules.size());
            for (IPatternMatcher elem : this.fSimplePatternUpRules.values()) {
                PatternMatcherAndEvaluator pmEvaluator = (PatternMatcherAndEvaluator)elem;
                ISymbol setSymbol = pmEvaluator.getSetSymbol();
                stream.writeUTF(setSymbol.toString());
                stream.writeUTF(pmEvaluator.getLHS().fullFormString());
                stream.writeUTF(pmEvaluator.getRHS().fullFormString());
                IExpr condition = pmEvaluator.getCondition();
                if (condition == null) {
                    stream.write(0);
                    continue;
                }
                stream.write(1);
                stream.writeUTF(condition.fullFormString());
            }
        }
    }
}

