/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluationEngine;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.core.patternmatching.PatternMatcherEquals;

public class DownRulesData
implements Serializable {
    private static final long serialVersionUID = 6438521796226265180L;
    private transient Map<IExpr, PatternMatcherEquals> fEqualDownRules = null;
    private transient ArrayListMultimap<Integer, IPatternMatcher> fSimplePatternDownRules = null;
    private transient List<IPatternMatcher> fPatternDownRules = null;

    public void clear() {
        this.fEqualDownRules = null;
        this.fSimplePatternDownRules = null;
        this.fPatternDownRules = null;
    }

    public IExpr evalDownRule(IExpr expression) {
        return this.evalDownRule(EvalEngine.get(), expression);
    }

    public IExpr evalDownRule(IEvaluationEngine ee, IExpr expression) {
        boolean showSteps = false;
        if (this.fEqualDownRules != null) {
            PatternMatcherEquals res;
            if (showSteps) {
                System.out.println("  EQUAL RULES");
            }
            if ((res = this.fEqualDownRules.get(expression)) != null) {
                if (showSteps) {
                    System.out.println("\n  >>>> " + res.getRHS().toString());
                }
                return res.getRHS();
            }
        }
        try {
            IExpr result;
            IPatternMatcher pmEvaluator;
            Integer hash;
            List list;
            if (this.fSimplePatternDownRules != null && expression instanceof IAST && (list = this.fSimplePatternDownRules.get((Object)(hash = Integer.valueOf(((IAST)expression).patternHashCode())))) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    pmEvaluator = (IPatternMatcher)((IPatternMatcher)list.get(i)).clone();
                    if (showSteps) {
                        IExpr rhs = pmEvaluator.getRHS();
                        if (rhs == null) {
                            rhs = F.Null;
                        }
                        System.out.println("  SIMPLE:  " + pmEvaluator.getLHS().toString() + "  :=  " + rhs.toString());
                    }
                    if ((result = pmEvaluator.eval(expression)) == null) continue;
                    if (showSteps) {
                        System.out.println("\n  >>>> " + result.toString());
                    }
                    return result;
                }
            }
            if (this.fPatternDownRules != null) {
                for (int i = 0; i < this.fPatternDownRules.size(); ++i) {
                    pmEvaluator = (IPatternMatcher)this.fPatternDownRules.get(i).clone();
                    if (showSteps) {
                        IExpr rhs = pmEvaluator.getRHS();
                        if (rhs == null) {
                            rhs = F.Null;
                        }
                        System.out.println("  COMPLEX: " + pmEvaluator.getLHS().toString() + "  :=  " + rhs.toString());
                    }
                    if ((result = pmEvaluator.eval(expression)) == null) continue;
                    if (showSteps) {
                        System.out.println("\n  >>>> " + result.toString());
                    }
                    return result;
                }
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return null;
    }

    public IPatternMatcher putDownRule(ISymbol setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, int priority) {
        if (equalRule) {
            this.fEqualDownRules = this.getEqualDownRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualDownRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        PatternMatcherAndEvaluator pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, leftHandSide, rightHandSide);
        if (pmEvaluator.isRuleWithoutPatterns()) {
            this.fEqualDownRules = this.getEqualDownRules();
            PatternMatcherEquals pmEquals = new PatternMatcherEquals(setSymbol, leftHandSide, rightHandSide);
            this.fEqualDownRules.put(leftHandSide, pmEquals);
            return pmEquals;
        }
        if (!this.isComplicatedPatternRule(leftHandSide)) {
            this.fSimplePatternDownRules = this.getSimplePatternDownRules();
            return this.addSimplePatternDownRule(leftHandSide, pmEvaluator);
        }
        this.fPatternDownRules = this.getPatternDownRules();
        if (F.isSystemInitialized) {
            for (int i = 0; i < this.fPatternDownRules.size(); ++i) {
                if (!pmEvaluator.equals(this.fPatternDownRules.get(i))) continue;
                this.fPatternDownRules.set(i, pmEvaluator);
                return pmEvaluator;
            }
        }
        this.fPatternDownRules.add(pmEvaluator);
        return pmEvaluator;
    }

    private PatternMatcher addSimplePatternDownRule(IExpr leftHandSide, PatternMatcher pmEvaluator) {
        Integer hash = ((IAST)leftHandSide).patternHashCode();
        if (F.isSystemInitialized && this.fSimplePatternDownRules.containsEntry((Object)hash, (Object)pmEvaluator)) {
            this.fSimplePatternDownRules.remove((Object)hash, (Object)pmEvaluator);
        }
        this.fSimplePatternDownRules.put((Object)hash, (Object)pmEvaluator);
        return pmEvaluator;
    }

    public PatternMatcher putDownRule(PatternMatcherAndInvoker pmEvaluator) {
        IExpr leftHandSide = pmEvaluator.getLHS();
        if (!this.isComplicatedPatternRule(leftHandSide)) {
            this.fSimplePatternDownRules = this.getSimplePatternDownRules();
            return this.addSimplePatternDownRule(leftHandSide, pmEvaluator);
        }
        this.fPatternDownRules = this.getPatternDownRules();
        for (int i = 0; i < this.fPatternDownRules.size(); ++i) {
            if (!pmEvaluator.equals(this.fPatternDownRules.get(i))) continue;
            this.fPatternDownRules.set(i, pmEvaluator);
            return pmEvaluator;
        }
        this.fPatternDownRules.add(pmEvaluator);
        return pmEvaluator;
    }

    private boolean isComplicatedPatternRule(IExpr lhsExpr) {
        if (lhsExpr.isAST()) {
            IAST lhsAST = (IAST)lhsExpr;
            if (lhsAST.size() > 1) {
                int attr = lhsAST.topHead().getAttributes();
                if ((4 & attr) == 4) {
                    return true;
                }
                if (((IExpr)lhsAST.get(1)).isAST()) {
                    IAST arg1 = (IAST)lhsAST.get(1);
                    if (arg1.isCondition()) {
                        return true;
                    }
                    for (int i = 2; i < arg1.size(); ++i) {
                        if (!((IExpr)arg1.get(i)).isPattern() || !((IPattern)arg1.get(i)).isDefault()) continue;
                        return true;
                    }
                } else {
                    if (((IExpr)lhsAST.get(1)).isPattern()) {
                        return true;
                    }
                    if (((IExpr)lhsAST.get(1)).isPatternSequence()) {
                        return true;
                    }
                }
                for (int i = 2; i < lhsAST.size(); ++i) {
                    if (!((IExpr)lhsAST.get(i)).isPattern() || !((IPattern)lhsAST.get(i)).isDefault()) continue;
                    return true;
                }
            }
        } else {
            if (lhsExpr.isPattern()) {
                return true;
            }
            if (lhsExpr.isPatternSequence()) {
                return true;
            }
        }
        return false;
    }

    public Map<IExpr, PatternMatcherEquals> getEqualDownRules() {
        if (this.fEqualDownRules == null) {
            this.fEqualDownRules = new HashMap<IExpr, PatternMatcherEquals>();
        }
        return this.fEqualDownRules;
    }

    private List<IPatternMatcher> getPatternDownRules() {
        if (this.fPatternDownRules == null) {
            this.fPatternDownRules = new ArrayList<IPatternMatcher>();
        }
        return this.fPatternDownRules;
    }

    private ArrayListMultimap<Integer, IPatternMatcher> getSimplePatternDownRules() {
        if (this.fSimplePatternDownRules == null) {
            this.fSimplePatternDownRules = ArrayListMultimap.create();
        }
        return this.fSimplePatternDownRules;
    }

    public List<IAST> definition() {
        IExpr condition;
        PatternMatcherAndEvaluator pmEvaluator;
        IAST ast;
        ISymbol setSymbol;
        ArrayList<IAST> definitionList = new ArrayList<IAST>();
        if (this.fEqualDownRules != null && this.fEqualDownRules.size() > 0) {
            for (IExpr key : this.fEqualDownRules.keySet()) {
                PatternMatcherEquals pme = this.fEqualDownRules.get(key);
                setSymbol = pme.getSetSymbol();
                ast = F.ast(setSymbol);
                ast.add(key);
                ast.add(pme.getRHS());
                definitionList.add(ast);
            }
        }
        if (this.fSimplePatternDownRules != null && this.fSimplePatternDownRules.size() > 0) {
            for (IPatternMatcher elem : this.fSimplePatternDownRules.values()) {
                if (!(elem instanceof PatternMatcherAndEvaluator)) continue;
                pmEvaluator = (PatternMatcherAndEvaluator)elem;
                setSymbol = pmEvaluator.getSetSymbol();
                ast = F.ast(setSymbol);
                ast.add(pmEvaluator.getLHS());
                condition = pmEvaluator.getCondition();
                if (condition != null) {
                    ast.add(F.Condition(pmEvaluator.getRHS(), condition));
                } else {
                    ast.add(pmEvaluator.getRHS());
                }
                definitionList.add(ast);
            }
        }
        if (this.fPatternDownRules != null && this.fPatternDownRules.size() > 0) {
            for (int i = 0; i < this.fPatternDownRules.size(); ++i) {
                if (!(this.fPatternDownRules.get(i) instanceof PatternMatcherAndEvaluator)) continue;
                pmEvaluator = (PatternMatcherAndEvaluator)this.fPatternDownRules.get(i);
                setSymbol = pmEvaluator.getSetSymbol();
                ast = F.ast(setSymbol);
                ast.add(pmEvaluator.getLHS());
                condition = pmEvaluator.getCondition();
                if (condition != null) {
                    ast.add(F.Condition(pmEvaluator.getRHS(), condition));
                } else {
                    ast.add(pmEvaluator.getRHS());
                }
                definitionList.add(ast);
            }
        }
        return definitionList;
    }

    public void readSymbol(ObjectInputStream stream) throws IOException {
        IExpr condition;
        int condLength;
        PatternMatcherAndEvaluator pmEvaluator;
        IExpr rhs;
        ISymbol setSymbol;
        String astString;
        EvalEngine engine = new EvalEngine(true, true);
        int len = stream.read();
        if (len > 0) {
            this.fEqualDownRules = new HashMap<IExpr, PatternMatcherEquals>();
            for (int i = 0; i < len; ++i) {
                astString = stream.readUTF();
                setSymbol = F.$s(astString);
                astString = stream.readUTF();
                IExpr key = engine.parse(astString);
                astString = stream.readUTF();
                IExpr value = engine.parse(astString);
                this.fEqualDownRules.put(key, new PatternMatcherEquals(setSymbol, key, value));
            }
        }
        if ((len = stream.read()) > 0) {
            this.fSimplePatternDownRules = ArrayListMultimap.create();
            for (int i = 0; i < len; ++i) {
                astString = stream.readUTF();
                setSymbol = F.$s(astString);
                astString = stream.readUTF();
                IExpr lhs = engine.parse(astString);
                astString = stream.readUTF();
                rhs = engine.parse(astString);
                pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, lhs, rhs);
                condLength = stream.read();
                if (condLength == 0) {
                    condition = null;
                } else {
                    astString = stream.readUTF();
                    condition = engine.parse(astString);
                    pmEvaluator.setCondition(condition);
                }
                this.addSimplePatternDownRule(lhs, pmEvaluator);
            }
        }
        if ((len = stream.read()) > 0) {
            this.fPatternDownRules = new ArrayList<IPatternMatcher>();
            int listLength = stream.read();
            for (int j = 0; j < listLength; ++j) {
                astString = stream.readUTF();
                setSymbol = F.$s(astString);
                astString = stream.readUTF();
                IExpr lhs = engine.parse(astString);
                astString = stream.readUTF();
                rhs = engine.parse(astString);
                pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, lhs, rhs);
                condLength = stream.read();
                if (condLength == 0) {
                    condition = null;
                } else {
                    astString = stream.readUTF();
                    condition = engine.parse(astString);
                    pmEvaluator.setCondition(condition);
                }
                this.addSimplePatternDownRule(lhs, pmEvaluator);
            }
        }
    }

    public void writeSymbol(ObjectOutputStream stream) throws IOException {
        IExpr condition;
        ISymbol setSymbol;
        PatternMatcherAndEvaluator pmEvaluator;
        if (this.fEqualDownRules == null || this.fEqualDownRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fEqualDownRules.size());
            for (IExpr key : this.fEqualDownRules.keySet()) {
                PatternMatcherEquals pme = this.fEqualDownRules.get(key);
                stream.writeUTF(pme.getSetSymbol().toString());
                stream.writeUTF(key.fullFormString());
                stream.writeUTF(pme.getRHS().fullFormString());
            }
        }
        if (this.fSimplePatternDownRules == null || this.fSimplePatternDownRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fSimplePatternDownRules.size());
            for (IPatternMatcher elem : this.fSimplePatternDownRules.values()) {
                pmEvaluator = (PatternMatcherAndEvaluator)elem;
                setSymbol = pmEvaluator.getSetSymbol();
                stream.writeUTF(setSymbol.toString());
                stream.writeUTF(pmEvaluator.getLHS().fullFormString());
                stream.writeUTF(pmEvaluator.getRHS().fullFormString());
                condition = pmEvaluator.getCondition();
                if (condition == null) {
                    stream.write(0);
                    continue;
                }
                stream.write(1);
                stream.writeUTF(condition.fullFormString());
            }
        }
        if (this.fPatternDownRules == null || this.fPatternDownRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fPatternDownRules.size());
            for (int i = 0; i < this.fPatternDownRules.size(); ++i) {
                pmEvaluator = (PatternMatcherAndEvaluator)this.fPatternDownRules.get(i);
                setSymbol = pmEvaluator.getSetSymbol();
                stream.writeUTF(setSymbol.toString());
                stream.writeUTF(pmEvaluator.getLHS().fullFormString());
                stream.writeUTF(pmEvaluator.getRHS().fullFormString());
                condition = pmEvaluator.getCondition();
                if (condition == null) {
                    stream.write(0);
                    continue;
                }
                stream.write(1);
                stream.writeUTF(condition.fullFormString());
            }
        }
    }
}

