/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import com.google.common.base.Function;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.matheclipse.commons.math.analysis.solvers.DifferentiableUnivariateFunction;
import org.matheclipse.core.basic.Alloc;
import org.matheclipse.core.eval.EvalDouble;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class UnaryNumerical
implements Function<IExpr, IExpr>,
DifferentiableUnivariateFunction {
    IExpr fFunction;
    ISymbol fVariable;
    EvalEngine fEngine;

    public UnaryNumerical(IExpr fn, ISymbol v, EvalEngine engine) {
        this.fVariable = v;
        this.fFunction = fn;
        this.fEngine = engine;
    }

    public IExpr apply(IExpr firstArg) {
        return F.evaln(F.subst(this.fFunction, F.Rule(this.fVariable, firstArg)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double value(double x) {
        double result = 0.0;
        double[] stack = Alloc.vector(10);
        try {
            this.fVariable.pushLocalVariable(Num.valueOf(x));
            result = EvalDouble.eval(stack, 0, this.fFunction);
        }
        finally {
            this.fVariable.popLocalVariable();
        }
        return result;
    }

    @Override
    public UnivariateFunction derivative() {
        IExpr expr = F.eval(F.D, this.fFunction, this.fVariable);
        return new UnaryNumerical(expr, this.fVariable, this.fEngine);
    }

    public ComplexNum value(ComplexNum z) {
        IExpr temp = this.apply(z);
        if (temp instanceof ComplexNum) {
            return (ComplexNum)temp;
        }
        if (temp instanceof INum) {
            return ComplexNum.valueOf((INum)temp);
        }
        throw new ArithmeticException("Expected numerical complex value object!");
    }

    public INum value(INum z) {
        IExpr temp = this.apply(z);
        if (temp instanceof INum) {
            return (INum)temp;
        }
        throw new ArithmeticException("Expected numerical double value object!");
    }
}

