/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex.reflection;

import org.matheclipse.core.form.tex.AbstractConverter;
import org.matheclipse.core.interfaces.IAST;

public class List
extends AbstractConverter {
    @Override
    public boolean convert(StringBuffer buf, IAST ast, int precedence) {
        if ((ast.getEvalFlags() & 0x20) == 32) {
            buf.append("\\begin{pmatrix} ");
            if (ast.size() > 1) {
                for (int i = 1; i < ast.size(); ++i) {
                    IAST row = ast.getAST(i);
                    for (int j = 1; j < row.size(); ++j) {
                        this.fFactory.convert(buf, row.get(j), 0);
                        if (j >= row.size() - 1) continue;
                        buf.append(" & ");
                    }
                    if (i >= ast.size() - 1) continue;
                    buf.append(" \\\\ ");
                }
            }
            buf.append(" \\end{pmatrix} ");
        } else if ((ast.getEvalFlags() & 0x40) == 64) {
            buf.append("\\begin{pmatrix} ");
            if (ast.size() > 1) {
                for (int j = 1; j < ast.size(); ++j) {
                    this.fFactory.convert(buf, ast.get(j), 0);
                    if (j >= ast.size() - 1) continue;
                    buf.append(" & ");
                }
            }
            buf.append(" \\end{pmatrix} ");
        } else {
            buf.append("\\{ ");
            if (ast.size() > 1) {
                this.fFactory.convert(buf, ast.get(1), 0);
                for (int i = 2; i < ast.size(); ++i) {
                    buf.append(',');
                    this.fFactory.convert(buf, ast.get(i), 0);
                }
            }
            buf.append("\\} ");
        }
        return true;
    }
}

