/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml.reflection;

import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.form.mathml.AbstractConverter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class MatrixForm
extends AbstractConverter {
    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        if (f.size() != 2) {
            return false;
        }
        IAST matrix = this.matrixQ((IExpr)f.get(1));
        if (matrix == null) {
            IAST vector = this.vectorQ((IExpr)f.get(1));
            if (vector == null) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "(");
            this.fFactory.tagStart(buf, "mtable");
            for (int i = 1; i < vector.size(); ++i) {
                IExpr temp = (IExpr)vector.get(i);
                this.fFactory.tagStart(buf, "mtr");
                this.fFactory.tagStart(buf, "mtd");
                this.fFactory.convert(buf, temp, 0);
                this.fFactory.tagEnd(buf, "mtd");
                this.fFactory.tagEnd(buf, "mtr");
            }
            this.fFactory.tagEnd(buf, "mtable");
            this.fFactory.tag(buf, "mo", ")");
            this.fFactory.tagEnd(buf, "mrow");
        } else {
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "(");
            this.fFactory.tagStart(buf, "mtable");
            for (int i = 1; i < matrix.size(); ++i) {
                IAST temp = (IAST)matrix.get(i);
                this.fFactory.tagStart(buf, "mtr");
                for (int j = 1; j < temp.size(); ++j) {
                    this.fFactory.tagStart(buf, "mtd");
                    this.fFactory.convert(buf, (IExpr)temp.get(j), 0);
                    this.fFactory.tagEnd(buf, "mtd");
                }
                this.fFactory.tagEnd(buf, "mtr");
            }
            this.fFactory.tagEnd(buf, "mtable");
            this.fFactory.tag(buf, "mo", ")");
            this.fFactory.tagEnd(buf, "mrow");
        }
        return true;
    }

    public IAST matrixQ(IExpr expr) {
        if (!(expr instanceof IAST)) {
            return null;
        }
        IAST list = (IAST)expr;
        if (!list.topHead().toString().equals(AST2Expr.LIST_STRING)) {
            return null;
        }
        int size = list.size();
        int subSize = -1;
        for (int i = 1; i < size; ++i) {
            IExpr temp = (IExpr)list.get(i);
            if (!(temp instanceof IAST)) {
                return null;
            }
            IAST subList = (IAST)temp;
            if (!subList.topHead().toString().equals(AST2Expr.LIST_STRING)) {
                return null;
            }
            if (subSize < 0) {
                subSize = subList.size();
                continue;
            }
            if (subSize == subList.size()) continue;
            return null;
        }
        return list;
    }

    public IAST vectorQ(IExpr expr) {
        if (!(expr instanceof IAST)) {
            return null;
        }
        IAST list = (IAST)expr;
        if (!list.topHead().toString().equals(AST2Expr.LIST_STRING)) {
            return null;
        }
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            IExpr temp = (IExpr)list.get(i);
            if (!(temp instanceof IAST) || !((IAST)temp).topHead().toString().equals(AST2Expr.LIST_STRING)) continue;
            return null;
        }
        return list;
    }
}

