/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml;

import java.util.Hashtable;
import org.matheclipse.core.form.mathml.IConverter;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public abstract class AbstractMathMLFormFactory {
    public static final boolean USE_IDENTIFIERS = false;
    public static final Hashtable<String, String> ENTITY_TABLE = new Hashtable(199);
    private final String fTagPrefix;

    public AbstractMathMLFormFactory() {
        this("");
    }

    public AbstractMathMLFormFactory(String tagPrefix) {
        this.fTagPrefix = tagPrefix;
    }

    public void entity(StringBuffer buf, String tag) {
        String entityValue = ENTITY_TABLE.get(tag);
        if (entityValue != null) {
            buf.append(entityValue.toString());
        } else {
            buf.append(tag);
        }
    }

    public void tag(StringBuffer buf, String tag, String data) {
        this.tagStart(buf, tag);
        this.entity(buf, data);
        this.tagEnd(buf, tag);
    }

    public void tagStart(StringBuffer buf, String tag) {
        buf.append("<" + this.fTagPrefix + tag + ">");
    }

    public void tagStart(StringBuffer buf, String tag, String attr0) {
        buf.append("<" + this.fTagPrefix + tag + " " + attr0 + ">");
    }

    public void tagEnd(StringBuffer buf, String tag) {
        buf.append("</" + this.fTagPrefix + tag + ">");
    }

    public void tagStartEnd(StringBuffer buf, String tag) {
        buf.append("<" + this.fTagPrefix + tag + " />");
    }

    public abstract String getReflectionNamespace();

    public abstract IConverter reflection(String var1);

    public abstract void convertDouble(StringBuffer var1, INum var2, int var3);

    public abstract void convertDoubleComplex(StringBuffer var1, IComplexNum var2, int var3);

    public abstract void convertInteger(StringBuffer var1, IInteger var2, int var3);

    public abstract void convertFraction(StringBuffer var1, IFraction var2, int var3);

    public abstract void convertComplex(StringBuffer var1, IComplex var2, int var3);

    public abstract void convertString(StringBuffer var1, String var2);

    public abstract void convertSymbol(StringBuffer var1, ISymbol var2);

    public abstract void convertHead(StringBuffer var1, IExpr var2);

    public abstract void convert(StringBuffer var1, IExpr var2, int var3);
}

