/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class PatternSequence
extends ExprImpl
implements IPatternSequence {
    private static final long serialVersionUID = 2773651826316158627L;
    IExpr fCondition;
    ISymbol fSymbol;
    boolean fDefault = false;
    int fIndex = -1;

    public static PatternSequence valueOf(ISymbol symbol, IExpr check, boolean def) {
        PatternSequence p = new PatternSequence();
        p.fSymbol = symbol;
        p.fCondition = check;
        p.fDefault = def;
        return p;
    }

    public static PatternSequence valueOf(ISymbol symbol, IExpr check) {
        PatternSequence p = new PatternSequence();
        p.fSymbol = symbol;
        p.fCondition = check;
        return p;
    }

    public static PatternSequence valueOf(ISymbol symbol) {
        return PatternSequence.valueOf(symbol, null);
    }

    private PatternSequence() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternSequence) {
            PatternSequence pattern = (PatternSequence)obj;
            if (this.fSymbol == pattern.fSymbol) {
                if (this.fCondition != null && pattern.fCondition != null) {
                    return this.fCondition.equals(pattern.fCondition);
                }
                return this.fCondition == pattern.fCondition;
            }
        }
        return false;
    }

    @Override
    public IExpr getCondition() {
        return this.fCondition;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }

    @Override
    public ISymbol getSymbol() {
        return this.fSymbol;
    }

    public int hashCode() {
        if (this.fSymbol == null) {
            return 203;
        }
        return 17 + this.fSymbol.hashCode();
    }

    @Override
    public int hierarchy() {
        return 512;
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        if (symbolsAsFactoryMethod) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("$ps(");
            if (this.fSymbol == null) {
                buffer.append("(ISymbol)null");
                if (this.fCondition != null) {
                    buffer.append("," + this.fCondition.internalFormString(symbolsAsFactoryMethod, 0));
                }
                if (this.fDefault) {
                    if (this.fCondition == null) {
                        buffer.append(",null");
                    }
                    buffer.append(",true");
                }
            } else {
                buffer.append("\"" + this.fSymbol.toString() + "\"");
                if (this.fCondition != null) {
                    buffer.append("," + this.fCondition.internalFormString(symbolsAsFactoryMethod, 0));
                }
                if (this.fDefault) {
                    buffer.append(",true");
                }
            }
            buffer.append(')');
            return buffer.toString();
        }
        return this.toString();
    }

    @Override
    public void setIndex(int i) {
        this.fIndex = i;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fSymbol == null) {
            buffer.append("__");
            if (this.fDefault) {
                buffer.append('.');
            }
            if (this.fCondition != null) {
                buffer.append(this.fCondition.toString());
            }
        } else if (this.fCondition == null) {
            buffer.append(this.fSymbol.toString());
            buffer.append("__");
            if (this.fDefault) {
                buffer.append('.');
            }
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append("__");
            if (this.fDefault) {
                buffer.append('.');
            }
            buffer.append(this.fCondition.toString());
        }
        return buffer.toString();
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer();
        if (this.fSymbol == null) {
            buf.append("BlankSequence[");
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            buf.append(']');
        } else {
            buf.append("PatternSequence[");
            buf.append(this.fSymbol.toString());
            buf.append(", ");
            buf.append("BlankSequence[");
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            buf.append("]]");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof PatternSequence) {
            int cp = this.fSymbol == null ? (((PatternSequence)obj).fSymbol == null ? -1 : 0) : (((PatternSequence)obj).fSymbol == null ? 1 : this.fSymbol.compareTo(((PatternSequence)obj).fSymbol));
            if (cp != 0) {
                return cp;
            }
            if (this.fCondition == null) {
                if (((PatternSequence)obj).fCondition != null) {
                    return -1;
                }
                return 0;
            }
            if (((PatternSequence)obj).fCondition == null) {
                return 1;
            }
            return this.fCondition.compareTo(((PatternSequence)obj).fCondition);
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public ISymbol head() {
        return F.PatternHead;
    }

    @Override
    public boolean isBlank() {
        return this.fSymbol == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConditionMatchedSequence(IAST sequence) {
        if (this.fCondition == null) {
            return true;
        }
        EvalEngine engine = EvalEngine.get();
        boolean traceMode = false;
        traceMode = engine.isTraceMode();
        Predicate<IExpr> matcher = Predicates.isTrue(engine, this.fCondition);
        try {
            for (int i = 1; i < sequence.size(); ++i) {
                if (((IExpr)sequence.get(i)).head().equals(this.fCondition)) continue;
                engine.setTraceMode(false);
                if (matcher.apply(sequence.get(i))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (traceMode) {
                engine.setTraceMode(true);
            }
        }
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return null;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isDefault() {
        return this.fDefault;
    }

    @Override
    public final boolean isPatternExpr() {
        return true;
    }

    @Override
    public final boolean isPatternSequence() {
        return true;
    }

    public boolean isCase(IExpr that) {
        PatternMatcher matcher = new PatternMatcher(this);
        return ((IPatternMatcher)matcher).apply(that);
    }
}

