/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.eval.util.IIndexFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class IndexTableGenerator {
    final int[] fIndexArray;
    final IAST fPrototypeList;
    final IIndexFunction<? extends IExpr> fFunction;
    int fIndex;
    int[] fCurrentIndex;

    public IndexTableGenerator(int[] indexArray, IAST prototypeList, IIndexFunction<? extends IExpr> function) {
        this.fIndexArray = indexArray;
        this.fPrototypeList = prototypeList;
        this.fFunction = function;
        this.fIndex = 0;
        this.fCurrentIndex = new int[indexArray.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExpr table() {
        if (this.fIndex < this.fIndexArray.length) {
            int iter = this.fIndexArray[this.fIndex];
            int index = this.fIndex++;
            try {
                IAST result = this.fPrototypeList.clone();
                int i = 0;
                while (i < iter) {
                    this.fCurrentIndex[index] = i++;
                    result.add(this.table());
                }
                IAST iAST = result;
                return iAST;
            }
            finally {
                --this.fIndex;
            }
        }
        return this.fFunction.evaluate(this.fCurrentIndex);
    }
}

