/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.math.MathException;

public class WrongArgumentType
extends MathException {
    private static final long serialVersionUID = -361382155486374959L;
    int fPosition;
    IExpr fArg;
    IAST fExpr;
    String fMessage;

    public WrongArgumentType(IAST expr, IExpr arg, int position) {
        this(expr, arg, position, null);
    }

    public WrongArgumentType(IExpr arg, String message) {
        this(null, arg, 0, message);
    }

    public WrongArgumentType(IAST expr, IExpr arg, int position, String message) {
        this.fPosition = position;
        this.fArg = arg;
        this.fExpr = expr;
        this.fMessage = message;
    }

    @Override
    public String getMessage() {
        if (this.fExpr == null) {
            return "The expression: " + this.fArg.toString() + " has a wrong type:\n" + this.fMessage;
        }
        if (this.fMessage == null) {
            return "The function: " + this.fExpr.toString() + " has wrong argument " + this.fArg.toString() + " at position:" + Integer.toString(this.fPosition);
        }
        if (this.fPosition < 0) {
            return "The function: " + this.fExpr.toString() + " has wrong type:\n" + this.fMessage;
        }
        return "The function: " + this.fExpr.toString() + " has wrong argument " + this.fArg.toString() + " at position:" + Integer.toString(this.fPosition) + ":\n" + this.fMessage;
    }
}

