/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import com.google.common.base.Predicate;
import java.util.Stack;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public final class TraceStack {
    final Stack<IAST> fStack = new Stack();
    final Predicate<IExpr> fMatcher;
    final IAST fList;
    IAST fTraceList;

    public TraceStack(Predicate<IExpr> matcher, IAST list) {
        this.fMatcher = matcher;
        this.fList = list;
        this.pushList();
    }

    public void pushList() {
        this.fTraceList = this.fList.clone();
        this.fStack.push(this.fTraceList);
    }

    public void popList() {
        IAST traceList = this.fTraceList;
        this.fStack.pop();
        this.fTraceList = this.fStack.peek();
        if (traceList.size() > 1) {
            this.fTraceList.add(traceList);
        }
    }

    public IAST getList() {
        return this.fTraceList;
    }

    public void add(IExpr expr) {
        if (this.fMatcher != null) {
            if (this.fMatcher.apply((Object)expr)) {
                this.fTraceList.add(expr);
            }
        } else {
            this.fTraceList.add(expr);
        }
    }

    public void addIfEmpty(IExpr expr) {
        if (this.fTraceList.size() == 1) {
            if (this.fMatcher != null) {
                if (this.fMatcher.apply((Object)expr)) {
                    this.fTraceList.add(expr);
                }
            } else {
                this.fTraceList.add(expr);
            }
        }
    }
}

