/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.Complex;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class JASIExpr {
    private final RingFactory<IExpr> fRingFactory;
    private final TermOrder fTermOrder;
    private final GenPolynomialRing<IExpr> fPolyFactory;
    private final GenPolynomialRing<BigInteger> fBigIntegerPolyFactory;
    private final List<? extends IExpr> fVariables;

    public JASIExpr(IExpr variable, RingFactory<IExpr> ringFactory) {
        ArrayList<? extends IExpr> varList = new ArrayList<IExpr>();
        varList.add(variable);
        this.fRingFactory = ringFactory;
        this.fVariables = varList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = new TermOrder(2);
        this.fPolyFactory = new GenPolynomialRing(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing((RingFactory)BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public JASIExpr(List<? extends IExpr> variablesList, RingFactory<IExpr> ringFactory) {
        this(variablesList, ringFactory, new TermOrder(2));
    }

    public JASIExpr(List<? extends IExpr> variablesList, RingFactory<IExpr> ringFactory, TermOrder termOrder) {
        this.fRingFactory = ringFactory;
        this.fVariables = variablesList;
        String[] vars = new String[this.fVariables.size()];
        for (int i = 0; i < this.fVariables.size(); ++i) {
            vars[i] = this.fVariables.get(i).toString();
        }
        this.fTermOrder = termOrder;
        this.fPolyFactory = new GenPolynomialRing(this.fRingFactory, this.fVariables.size(), this.fTermOrder, vars);
        this.fBigIntegerPolyFactory = new GenPolynomialRing((RingFactory)BigInteger.ZERO, this.fVariables.size(), this.fTermOrder, vars);
    }

    public GenPolynomial<IExpr> expr2IExprJAS(IExpr exprPoly) throws JASConversionException {
        try {
            return this.expr2IExprPoly(exprPoly);
        }
        catch (Exception ae) {
            throw new JASConversionException();
        }
    }

    private GenPolynomial<IExpr> expr2IExprPoly(IExpr exprPoly) throws ArithmeticException, ClassCastException {
        if (exprPoly instanceof IAST) {
            IAST ast = (IAST)exprPoly;
            GenPolynomial result = this.fPolyFactory.getZERO();
            GenPolynomial<IExpr> p = this.fPolyFactory.getZERO();
            if (ast.isPlus()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.sum(p);
                }
                return result;
            }
            if (ast.isTimes()) {
                IExpr expr = (IExpr)ast.get(1);
                result = this.expr2IExprPoly(expr);
                for (int i = 2; i < ast.size(); ++i) {
                    expr = (IExpr)ast.get(i);
                    p = this.expr2IExprPoly(expr);
                    result = result.multiply(p);
                }
                return result;
            }
            if (ast.isPower()) {
                IExpr expr = (IExpr)ast.get(1);
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(expr)) continue;
                    int exponent = -1;
                    try {
                        exponent = Validate.checkPowerExponent(ast);
                    }
                    catch (WrongArgumentType e) {
                        // empty catch block
                    }
                    if (exponent < 0) {
                        throw new ArithmeticException("JASConvert:expr2Poly - invalid exponent: " + ((IExpr)ast.get(2)).toString());
                    }
                    ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)exponent);
                    return this.fPolyFactory.getONE().multiply(e);
                }
            }
        } else {
            if (exprPoly instanceof ISymbol) {
                for (int i = 0; i < this.fVariables.size(); ++i) {
                    if (!this.fVariables.get(i).equals(exprPoly)) continue;
                    ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)1L);
                    return this.fPolyFactory.getONE().multiply(e);
                }
                return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
            }
            if (exprPoly instanceof IInteger) {
                return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
            }
            if (exprPoly instanceof IFraction) {
                return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
            }
        }
        if (exprPoly.isFree((Predicate<IExpr>)Predicates.in(this.fVariables), true)) {
            return new GenPolynomial(this.fPolyFactory, (RingElem)exprPoly);
        }
        for (int i = 0; i < this.fVariables.size(); ++i) {
            if (!this.fVariables.get(i).equals(exprPoly)) continue;
            ExpVector e = ExpVector.create((int)this.fVariables.size(), (int)i, (long)1L);
            return this.fPolyFactory.getONE().multiply(e);
        }
        throw new ClassCastException(exprPoly.toString());
    }

    public Object[] factorTerms(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficientsFactor(this.fBigIntegerPolyFactory, A);
    }

    public GenPolynomialRing<IExpr> getPolynomialRingFactory() {
        return this.fPolyFactory;
    }

    public GenPolynomial<BigInteger> integerFromRationalCoefficients(GenPolynomial<BigRational> A) {
        return PolyUtil.integerFromRationalCoefficients(this.fBigIntegerPolyFactory, A);
    }

    public IExpr integerPoly2Expr(GenPolynomial<BigInteger> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IAST result = F.Plus();
        for (Monomial monomial : poly) {
            BigInteger coeff = (BigInteger)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IInteger coeffValue = F.integer(coeff.getVal());
            IAST monomTimes = F.Times((IExpr)coeffValue);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            if (monomTimes.size() == 2) {
                result.add(monomTimes.get(1));
                continue;
            }
            result.add(monomTimes);
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }

    public IExpr complexPoly2Expr(GenPolynomial<Complex<BigRational>> poly) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.C0;
        }
        IAST result = F.Plus();
        for (Monomial monomial : poly) {
            Complex coeff = (Complex)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            BigRational re = (BigRational)coeff.getRe();
            BigRational im = (BigRational)coeff.getIm();
            IAST monomTimes = F.Times((IExpr)F.complex(F.fraction(re.numerator(), re.denominator()), F.fraction(im.numerator(), im.denominator())));
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                monomTimes.add(F.Power(this.fVariables.get(i), F.integer(lExp)));
            }
            if (monomTimes.size() == 2) {
                result.add(monomTimes.get(1));
                continue;
            }
            result.add(monomTimes);
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }

    public IAST exprPoly2Expr(GenPolynomial<IExpr> poly, IExpr variable) throws ArithmeticException, ClassCastException {
        if (poly.length() == 0) {
            return F.Plus((IExpr)F.C0);
        }
        boolean getVar = variable == null;
        IAST result = F.Plus();
        for (Monomial monomial : poly) {
            IExpr coeff = (IExpr)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IAST monomTimes = F.Times(coeff);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                if (getVar) {
                    variable = this.fVariables.get(i);
                }
                monomTimes.add(F.Power(variable, F.integer(lExp)));
            }
            result.add(monomTimes);
        }
        return result;
    }
}

