/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import java.util.IdentityHashMap;
import java.util.Map;
import org.matheclipse.core.builtin.function.Condition;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.math.MathException;

public class Module
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (ast.arg1().isList()) {
            IAST lst = (IAST)ast.arg1();
            IExpr arg2 = (IExpr)ast.get(2);
            EvalEngine engine = EvalEngine.get();
            return Module.evalModule(lst, arg2, engine);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkModuleCondition(IExpr arg1, IExpr arg2, EvalEngine engine) {
        if (arg1.isList()) {
            IAST intializerList = (IAST)arg1;
            int moduleCounter = engine.incModuleCounter();
            String varAppend = "$" + moduleCounter;
            IdentityHashMap<ISymbol, ISymbol> moduleVariables = new IdentityHashMap<ISymbol, ISymbol>();
            try {
                Module.rememberVariables(intializerList, engine, varAppend, moduleVariables);
                IExpr result = F.subst(arg2, Functors.rules(moduleVariables));
                if (result.isCondition()) {
                    boolean bl = Condition.checkCondition(result.getAt(1), result.getAt(2), engine);
                    return bl;
                }
                if (result.isModule()) {
                    boolean bl = Module.checkModuleCondition(result.getAt(1), result.getAt(2), engine);
                    return bl;
                }
            }
            finally {
                engine.removeUserVariables(moduleVariables);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpr evalModule(IAST intializerList, IExpr arg2, EvalEngine engine) {
        int moduleCounter = engine.incModuleCounter();
        String varAppend = "$" + moduleCounter;
        IdentityHashMap<ISymbol, ISymbol> moduleVariables = new IdentityHashMap<ISymbol, ISymbol>();
        try {
            IExpr temp;
            Module.rememberVariables(intializerList, engine, varAppend, moduleVariables);
            IExpr iExpr = temp = engine.evaluate(F.subst(arg2, Functors.rules(moduleVariables)));
            return iExpr;
        }
        finally {
            engine.removeUserVariables(moduleVariables);
        }
    }

    private static void rememberVariables(IAST variablesList, EvalEngine engine, String varAppend, Map<ISymbol, ISymbol> variables) {
        for (int i = 1; i < variablesList.size(); ++i) {
            IAST setFun;
            ISymbol newSymbol;
            ISymbol oldSymbol;
            if (((IExpr)variablesList.get(i)).isSymbol()) {
                oldSymbol = (ISymbol)variablesList.get(i);
                newSymbol = F.$s(oldSymbol.toString() + varAppend);
                variables.put(oldSymbol, newSymbol);
                newSymbol.pushLocalVariable();
                continue;
            }
            if (!((IExpr)variablesList.get(i)).isAST(F.Set, 3) || !(setFun = (IAST)variablesList.get(i)).arg1().isSymbol()) continue;
            oldSymbol = (ISymbol)setFun.arg1();
            newSymbol = F.$s(oldSymbol.toString() + varAppend);
            variables.put(oldSymbol, newSymbol);
            IExpr rightHandSide = setFun.arg2();
            try {
                rightHandSide = engine.evaluate(rightHandSide);
            }
            catch (MathException me) {
                // empty catch block
            }
            newSymbol.pushLocalVariable(rightHandSide);
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

