/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class AppendTo
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        ISymbol sym = Validate.checkSymbolType(ast, 1);
        IExpr arg2 = F.eval(ast.arg2());
        AppendToFunction function = new AppendToFunction(arg2);
        IExpr[] results = sym.reassignSymbolValue(function, F.AppendTo);
        if (results != null) {
            return results[1];
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(32);
    }

    class AppendToFunction
    implements Function<IExpr, IExpr> {
        private final IExpr value;

        public AppendToFunction(IExpr value) {
            this.value = value;
        }

        public IExpr apply(IExpr symbolValue) {
            if (!symbolValue.isAST()) {
                return null;
            }
            return ((IAST)symbolValue).clone().append(this.value);
        }
    }
}

