/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTriggerDef;

public class SqlJetTriggerDef
implements ISqlJetTriggerDef {
    private String name;
    private boolean temporary;
    private boolean ifNotExists;
    private String databaseName;
    private String tableName;
    private String sqlStatement;
    private long rowId;

    public SqlJetTriggerDef(String sql, CommonTree ast) {
        CommonTree optionsNode = (CommonTree)ast.getChild(0);
        this.sqlStatement = sql;
        this.temporary = SqlJetTableDef.hasOption(optionsNode, "temporary");
        this.ifNotExists = SqlJetTableDef.hasOption(optionsNode, "exists");
        CommonTree nameNode = (CommonTree)ast.getChild(1);
        this.name = nameNode.getText();
        this.tableName = nameNode.getChildCount() > 0 ? nameNode.getChild(0).getText() : null;
        this.databaseName = nameNode.getChildCount() > 1 ? nameNode.getChild(1).getText() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isKeepExisting() {
        return this.ifNotExists;
    }

    @Override
    public String toSQL() {
        return this.sqlStatement;
    }

    public String toString() {
        return this.toSQL();
    }

    public long getRowId() {
        return this.rowId;
    }

    public void setRowId(long rowId) {
        this.rowId = rowId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }
}

