/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetFunctionExpression;

public class SqlJetFunctionExpression
extends SqlJetExpression
implements ISqlJetFunctionExpression {
    private final String name;
    private final boolean distinct;
    private final boolean all;
    private final List<ISqlJetExpression> arguments;

    public SqlJetFunctionExpression(CommonTree ast) throws SqlJetException {
        assert ("function_expression".equalsIgnoreCase(ast.getText()));
        this.name = ast.getChild(0).getText();
        if ("*".equals(ast.getChild(1).getText())) {
            this.all = true;
            this.distinct = false;
            this.arguments = Collections.emptyList();
        } else {
            this.all = false;
            ArrayList<ISqlJetExpression> arguments = new ArrayList<ISqlJetExpression>();
            int i = 1;
            CommonTree child = (CommonTree)ast.getChild(i);
            if (child != null && "distinct".equalsIgnoreCase(child.getText())) {
                this.distinct = true;
                ++i;
            } else {
                this.distinct = false;
            }
            while (i < ast.getChildCount()) {
                child = (CommonTree)ast.getChild(i);
                if (!"distinct".equalsIgnoreCase(child.getText())) {
                    ISqlJetExpression argument = SqlJetFunctionExpression.create(child);
                    arguments.add(argument);
                }
                ++i;
            }
            this.arguments = Collections.unmodifiableList(arguments);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean areDistinctArguments() {
        return this.distinct;
    }

    @Override
    public List<ISqlJetExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isAll() {
        return this.all;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(" (");
        if (this.isAll()) {
            buffer.append('*');
        } else {
            if (this.areDistinctArguments()) {
                buffer.append("DISTINCT ");
            }
            for (int idx = 0; idx < this.getArguments().size(); ++idx) {
                if (idx > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.getArguments().get(idx));
            }
        }
        buffer.append(')');
        return buffer.toString();
    }
}

