/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapCursor;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapIndex;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapTable;
import org.tmatesoft.sqljet.core.map.ISqlJetMap;
import org.tmatesoft.sqljet.core.map.ISqlJetMapCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndex;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTable;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTransaction;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetMap
implements ISqlJetMap {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private boolean writable;
    private ISqlJetMapTable mapTable;
    private ISqlJetMapIndex mapIndex;

    public SqlJetMap(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) {
        this.mapDb = mapDb;
        this.btree = btree;
        this.mapDef = mapDef;
        this.writable = writable;
    }

    @Override
    public ISqlJetMapCursor getCursor() throws SqlJetException {
        return (ISqlJetMapCursor)this.mapDb.runSynchronized(new ISqlJetEngineSynchronized(){

            @Override
            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return new SqlJetMapCursor(SqlJetMap.this.mapDb, SqlJetMap.this.btree, SqlJetMap.this.mapDef, SqlJetMap.this.writable);
            }
        });
    }

    @Override
    public void put(final Object[] key, final Object[] value) throws SqlJetException {
        this.mapDb.runWriteTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                try (ISqlJetMapCursor cursor = SqlJetMap.this.getCursor();){
                    cursor.put(key, value);
                    Object var3_3 = null;
                    return var3_3;
                }
            }
        });
    }

    @Override
    public Object[] get(final Object[] key) throws SqlJetException {
        return (Object[])this.mapDb.runReadTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                try (ISqlJetMapCursor cursor = SqlJetMap.this.getCursor();){
                    if (cursor.goToKey(key)) {
                        Object[] objectArray = cursor.getValue();
                        return objectArray;
                    }
                    Object var3_4 = null;
                    return var3_4;
                }
            }
        });
    }

    @Override
    public synchronized ISqlJetMapTable getMapTable() throws SqlJetException {
        if (this.mapTable == null) {
            this.mapTable = new SqlJetMapTable(this.mapDb, this.btree, this.mapDef, this.writable);
        }
        return this.mapTable;
    }

    @Override
    public synchronized ISqlJetMapIndex getMapIndex() throws SqlJetException {
        if (this.mapIndex == null) {
            ISqlJetIndexDef indexDef = this.mapDef.getIndexDef();
            this.mapIndex = new SqlJetMapIndex(this.mapDb, this.btree, indexDef, this.writable);
        }
        return this.mapIndex;
    }
}

