/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetDeviceCharacteristics;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetSyncFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;

public class SqlJetFile
implements ISqlJetFile {
    private static final boolean SQLJET_LOG_FILES = SqlJetUtility.getBoolSysProp("SQLJET_LOG_FILES", false);
    private static final boolean SQLJET_LOG_FILES_PERFORMANCE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_FILES_PERFORMANCE", false);
    private static Logger filesLogger = Logger.getLogger("SQLJET_LOG_FILES");
    public static final int SQLJET_DEFAULT_SECTOR_SIZE = 512;
    private long timer_start = 0L;
    private long timer_elapsed = 0L;
    private static final Map<String, OpenFile> openFiles = new HashMap<String, OpenFile>();
    private SqlJetFileType fileType;
    private Set<SqlJetFileOpenPermission> permissions;
    private RandomAccessFile file;
    private File filePath;
    private String filePathResolved;
    private boolean noLock;
    private SqlJetLockType lockType = SqlJetLockType.NONE;
    private Map<SqlJetLockType, FileLock> locks = new ConcurrentHashMap<SqlJetLockType, FileLock>();
    private OpenFile openCount = null;
    private LockInfo lockInfo = null;
    private SqlJetFileLockManager fileLockManager;
    static final Set<SqlJetDeviceCharacteristics> noDeviceCharacteristircs = SqlJetUtility.noneOf(SqlJetDeviceCharacteristics.class);

    private static void OSTRACE(String format, Object ... args) {
        if (SQLJET_LOG_FILES) {
            SqlJetUtility.log(filesLogger, format, args);
        }
    }

    private long TIMER_ELAPSED() {
        return this.timer_elapsed;
    }

    private void TIMER_END() {
        if (SQLJET_LOG_FILES_PERFORMANCE) {
            this.timer_elapsed = System.nanoTime() - this.timer_start;
        }
    }

    private void TIMER_START() {
        if (SQLJET_LOG_FILES_PERFORMANCE) {
            this.timer_start = System.nanoTime();
        }
    }

    private String getpid() {
        return "thread ['" + Thread.currentThread().getName() + "]";
    }

    private String locktypeName(SqlJetLockType lockType) {
        return lockType != null ? lockType.name() : null;
    }

    SqlJetFile(SqlJetFileSystem fileSystem, RandomAccessFile file, File filePath, SqlJetFileType fileType, Set<SqlJetFileOpenPermission> permissions, boolean noLock) {
        this.file = file;
        this.filePath = filePath;
        this.filePathResolved = filePath.getAbsolutePath();
        this.fileType = fileType;
        this.permissions = EnumSet.copyOf(permissions);
        this.noLock = noLock;
        this.fileLockManager = new SqlJetFileLockManager(this.filePathResolved, file.getChannel());
        this.findLockInfo();
        SqlJetFile.OSTRACE("OPEN    %s\n", this.filePath);
    }

    @Override
    public SqlJetFileType getFileType() {
        return this.fileType;
    }

    @Override
    public synchronized Set<SqlJetFileOpenPermission> getPermissions() {
        HashSet<SqlJetFileOpenPermission> permissionsCopy = new HashSet<SqlJetFileOpenPermission>();
        for (SqlJetFileOpenPermission permission : this.permissions) {
            permissionsCopy.add(permission);
        }
        return permissionsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SqlJetException {
        if (null == this.file) {
            return;
        }
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            this.unlock(SqlJetLockType.NONE);
            if (!this.noLock && null != this.openCount && null != this.openCount.lockInfoMap && this.openCount.lockInfoMap.size() > 0) {
                for (LockInfo l : this.openCount.lockInfoMap.values()) {
                    if (l.sharedLockCount <= 0) continue;
                    this.openCount.pending.add(this.file);
                    return;
                }
            }
            this.releaseLockInfo();
            try {
                this.file.close();
            }
            catch (IOException e) {
                throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
            }
            finally {
                this.file = null;
            }
        }
        if (this.filePath != null && this.permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE) && !SqlJetFileUtil.deleteFile(this.filePath)) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_DELETE, String.format("Can't delete file '%s'", this.filePath.getPath()));
        }
        SqlJetFile.OSTRACE("CLOSE   %s\n", this.filePath);
    }

    @Override
    public synchronized int read(ISqlJetMemoryPointer buffer, int amount, long offset) throws SqlJetIOException {
        assert (amount > 0);
        assert (offset >= 0L);
        assert (buffer != null);
        assert (buffer.remaining() >= amount);
        assert (this.file != null);
        try {
            this.TIMER_START();
            int read = buffer.readFromFile(this.file, offset, amount);
            this.TIMER_END();
            SqlJetFile.OSTRACE("READ %s %5d %7d %d\n", this.filePath, read, offset, this.TIMER_ELAPSED());
            return read < 0 ? 0 : read;
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_READ, (Throwable)e);
        }
    }

    @Override
    public synchronized void write(ISqlJetMemoryPointer buffer, int amount, long offset) throws SqlJetIOException {
        assert (amount > 0);
        assert (offset >= 0L);
        assert (buffer != null);
        assert (buffer.remaining() >= amount);
        assert (this.file != null);
        try {
            this.TIMER_START();
            int write = buffer.writeToFile(this.file, offset, amount);
            this.TIMER_END();
            SqlJetFile.OSTRACE("WRITE %s %5d %7d %d\n", this.filePath, write, offset, this.TIMER_ELAPSED());
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_WRITE, (Throwable)e);
        }
    }

    @Override
    public synchronized void truncate(long size) throws SqlJetIOException {
        assert (size >= 0L);
        assert (this.file != null);
        try {
            this.file.setLength(size);
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_TRUNCATE, (Throwable)e);
        }
    }

    @Override
    public synchronized void sync(Set<SqlJetSyncFlags> syncFlags) throws SqlJetIOException {
        assert (this.file != null);
        try {
            SqlJetFile.OSTRACE("SYNC    %s\n", this.filePath);
            boolean syncMetaData = syncFlags != null && syncFlags.contains((Object)SqlJetSyncFlags.NORMAL);
            this.file.getChannel().force(syncMetaData);
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_FSYNC, (Throwable)e);
        }
    }

    @Override
    public synchronized long fileSize() throws SqlJetException {
        assert (this.file != null);
        try {
            return this.file.getChannel().size();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
        }
    }

    @Override
    public synchronized SqlJetLockType getLockType() {
        return this.lockType;
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized boolean lock(SqlJetLockType lockType) throws SqlJetIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 13[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean unlock(SqlJetLockType lockType) throws SqlJetIOException {
        assert (lockType != null);
        assert (this.file != null);
        if (this.noLock) {
            return false;
        }
        SqlJetFile.OSTRACE("UNLOCK  %s %s was %s(%s,%s) pid=%s\n", this.filePath, this.locktypeName(lockType), this.locktypeName(this.lockType), this.locktypeName(this.lockInfo.lockType), this.lockInfo.sharedLockCount, this.getpid());
        assert (SqlJetLockType.SHARED.compareTo(lockType) >= 0);
        if (this.lockType.compareTo(lockType) <= 0) {
            return true;
        }
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            assert (this.lockInfo != null);
            assert (this.lockInfo.sharedLockCount > 0);
            try {
                if (SqlJetLockType.SHARED.compareTo(this.lockType) < 0) {
                    FileLock pendingLock;
                    Iterator reservedLock;
                    if (SqlJetLockType.SHARED == lockType) {
                        FileLock exclusiveLock = this.locks.get((Object)SqlJetLockType.EXCLUSIVE);
                        if (null != exclusiveLock) {
                            exclusiveLock.release();
                            this.locks.remove((Object)SqlJetLockType.EXCLUSIVE);
                        }
                        if (null == this.locks.get((Object)SqlJetLockType.SHARED)) {
                            FileLock sharedLock = this.fileLockManager.lock(0x40000002L, 510L, true);
                            if (null == sharedLock) {
                                return false;
                            }
                            this.locks.put(SqlJetLockType.SHARED, sharedLock);
                            this.lockInfo.sharedLock = sharedLock;
                        }
                    }
                    if (null != (reservedLock = this.locks.get((Object)SqlJetLockType.RESERVED))) {
                        ((FileLock)((Object)reservedLock)).release();
                        this.locks.remove((Object)SqlJetLockType.RESERVED);
                    }
                    if (null != (pendingLock = this.locks.get((Object)SqlJetLockType.PENDING))) {
                        pendingLock.release();
                        this.locks.remove((Object)SqlJetLockType.PENDING);
                    }
                    this.lockInfo.lockType = SqlJetLockType.SHARED;
                }
                if (lockType == SqlJetLockType.NONE) {
                    this.lockInfo.sharedLockCount--;
                    if (this.lockInfo.sharedLockCount == 0) {
                        this.lockInfo.sharedLockCount = 1;
                        for (FileLock l : this.locks.values()) {
                            l.release();
                        }
                        this.locks.clear();
                        this.lockInfo.sharedLockCount = 0;
                        this.lockInfo.lockType = SqlJetLockType.NONE;
                    }
                    this.openCount.numLock--;
                    assert (this.openCount.numLock >= 0);
                    if (this.openCount.numLock == 0 && null != this.openCount.pending && this.openCount.pending.size() > 0) {
                        for (RandomAccessFile f : this.openCount.pending) {
                            f.close();
                        }
                        this.openCount.pending.clear();
                    }
                }
                this.lockType = lockType;
            }
            catch (IOException e) {
                throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_LOCK, (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean checkReservedLock() {
        FileLock reservedLock;
        boolean reserved;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            boolean bl;
                            reserved = false;
                            try {
                                if (!this.noLock) break block12;
                                bl = false;
                            }
                            catch (Throwable throwable) {
                                SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                                throw throwable;
                            }
                            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                            return bl;
                        }
                        if (null != this.file) break block13;
                        boolean bl = false;
                        SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                        return bl;
                    }
                    if (null != this.lockInfo) break block14;
                    boolean bl = false;
                    SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                    return bl;
                }
                Map<String, OpenFile> map = openFiles;
                // MONITORENTER : map
                if (SqlJetLockType.SHARED.compareTo(this.lockInfo.lockType) >= 0) break block15;
                boolean bl = true;
                // MONITOREXIT : map
                SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                return bl;
            }
            reservedLock = this.fileLockManager.tryLock(0x40000001L, 1L, false);
            if (null != reservedLock) break block16;
            reserved = true;
            boolean bl = true;
            // MONITOREXIT : map
            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
            return bl;
        }
        try {
            reservedLock.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = false;
        SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
        return bl;
    }

    @Override
    public int sectorSize() {
        return 512;
    }

    @Override
    public Set<SqlJetDeviceCharacteristics> deviceCharacteristics() {
        return noDeviceCharacteristircs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void findLockInfo() {
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            LockInfo fileLockInfo;
            if (null == this.openCount) {
                OpenFile fileOpenCount = openFiles.get(this.filePathResolved);
                if (null != fileOpenCount) {
                    this.openCount = fileOpenCount;
                    this.openCount.numRef++;
                } else {
                    this.openCount = new OpenFile();
                    openFiles.put(this.filePathResolved, this.openCount);
                }
            }
            if (null != (fileLockInfo = (LockInfo)this.openCount.lockInfoMap.get(Thread.currentThread()))) {
                this.lockInfo = fileLockInfo;
                this.lockInfo.numRef++;
            } else {
                this.lockInfo = new LockInfo();
                this.openCount.lockInfoMap.put(Thread.currentThread(), this.lockInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockInfo() {
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            if (null != this.lockInfo) {
                this.lockInfo.numRef--;
                if (0 == this.lockInfo.numRef) {
                    if (null != this.openCount) {
                        this.openCount.lockInfoMap.remove(Thread.currentThread());
                    }
                    this.lockInfo = null;
                }
            }
            if (null != this.openCount) {
                this.openCount.numRef--;
                if (0 == this.openCount.numRef) {
                    openFiles.remove(this.filePathResolved);
                    this.openCount = null;
                }
            }
        }
    }

    @Override
    public boolean isMemJournal() {
        return false;
    }

    private static class OpenFile {
        private int numRef = 1;
        private int numLock = 0;
        private Map<Thread, LockInfo> lockInfoMap = new ConcurrentHashMap<Thread, LockInfo>();
        private List<RandomAccessFile> pending = new ArrayList<RandomAccessFile>();

        private OpenFile() {
        }

        static /* synthetic */ int access$508(OpenFile x0) {
            return x0.numLock++;
        }
    }

    private static class LockInfo {
        private SqlJetLockType lockType = SqlJetLockType.NONE;
        private int sharedLockCount = 0;
        private int numRef = 1;
        private FileLock sharedLock = null;

        private LockInfo() {
        }

        static /* synthetic */ int access$108(LockInfo x0) {
            return x0.sharedLockCount++;
        }

        static /* synthetic */ FileLock access$400(LockInfo x0) {
            return x0.sharedLock;
        }
    }
}

