/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.browser.core.schema;

import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;

class SchemaTreeNode {
    private String myName;
    private String myObjectType;
    private String myType;
    private String mySchema;
    private List<SchemaTreeNode> myChildren = new ArrayList<SchemaTreeNode>();

    SchemaTreeNode() {
        this.myName = "<root>";
        this.myObjectType = "root";
        this.myType = "";
        this.mySchema = "";
    }

    SchemaTreeNode(ISqlJetTableDef table) {
        this.myName = table.getName();
        this.myObjectType = "table";
        this.myType = "";
        this.mySchema = table.toSQL();
    }

    SchemaTreeNode(ISqlJetIndexDef index) {
        this.myName = index.getName();
        this.myObjectType = "index";
        this.myType = "";
        this.mySchema = index.toSQL();
    }

    SchemaTreeNode(ISqlJetTableDef table, ISqlJetColumnDef column) {
        this.myName = column.getName();
        this.myObjectType = "field";
        List<Object> names = column.getType() == null ? new ArrayList() : column.getType().getNames();
        List<ISqlJetColumnConstraint> constraints = column.getConstraints();
        StringBuffer type = new StringBuffer();
        for (String string : names) {
            if (type.length() > 0) {
                type.append(' ');
            }
            type.append(string);
        }
        for (ISqlJetColumnConstraint iSqlJetColumnConstraint : constraints) {
            if (type.length() > 0) {
                type.append(' ');
            }
            type.append(iSqlJetColumnConstraint.toString());
        }
        this.myType = type.toString();
        this.mySchema = "";
    }

    public void addChild(SchemaTreeNode child) {
        this.myChildren.add(child);
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    public SchemaTreeNode getChildAt(int index) {
        return this.myChildren.get(index);
    }

    public int getIndexOfChild(SchemaTreeNode child) {
        return this.myChildren.indexOf(child);
    }

    public String getName() {
        return this.myName;
    }

    public String getTypeName() {
        return this.myObjectType;
    }

    public String getType() {
        return this.myType;
    }

    public String getSchema() {
        return this.mySchema;
    }

    public String toString() {
        return this.getName();
    }
}

