/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freehep.swing.ColorConverter;

public class ColorNameChooserPanel
extends AbstractColorChooserPanel
implements ListSelectionListener {
    private JList list;

    @Override
    protected void buildChooser() {
        String[] names = ColorConverter.getNames();
        Vector<IconLabel> labels = new Vector<IconLabel>(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                Color c = ColorConverter.get(names[i]);
                IconLabel cl = new IconLabel(names[i], c);
                labels.add(cl);
                continue;
            }
            catch (ColorConverter.ColorConversionException e) {
                e.printStackTrace();
            }
        }
        this.list = new JList(labels);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(-1);
        this.list.setCellRenderer(new ColorListCellRenderer());
        this.list.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add(scrollPane);
    }

    @Override
    public void updateChooser() {
    }

    @Override
    public String getDisplayName() {
        return "By Name";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Color color = null;
        int index = this.list.getSelectedIndex();
        if (index >= 0) {
            color = ((IconLabel)this.list.getSelectedValue()).getColor();
        }
        this.getColorSelectionModel().setSelectedColor(color);
    }

    private class ColorIcon
    implements Icon {
        private Color color;
        private int sizeX = 16;
        private int sizeY = 10;

        ColorIcon(Color color) {
            this.color = color;
        }

        public void setIconHeight(int size) {
            this.sizeY = size;
        }

        public void setIconWidth(int size) {
            this.sizeX = size;
        }

        @Override
        public int getIconHeight() {
            return this.sizeY;
        }

        @Override
        public int getIconWidth() {
            return this.sizeX;
        }

        @Override
        public void paintIcon(Component p1, Graphics g, int x, int y) {
            Color save = g.getColor();
            g.setColor(this.color == null ? ColorNameChooserPanel.this.getBackground() : this.color);
            g.fill3DRect(x, y, this.sizeX, this.sizeY, true);
            g.setColor(save);
        }
    }

    private class IconLabel {
        private Color color;
        private String name;
        private ColorIcon icon;

        IconLabel(String name, Color color) {
            this.name = name;
            this.color = color;
            this.icon = new ColorIcon(color);
        }

        public Color getColor() {
            return this.color;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ColorListCellRenderer
    extends DefaultListCellRenderer {
        ColorListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof IconLabel) {
                Icon icon = ((IconLabel)value).getIcon();
                this.setIcon(icon);
            }
            return c;
        }
    }
}

