/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Enumeration;
import java.util.Hashtable;
import org.freehep.rtti.IClass;

public class IPackage {
    private String name;
    private Hashtable classes = new Hashtable();

    IPackage(String name) {
        this.name = name == null || name.equals("") ? "<default>" : name;
    }

    public String getName() {
        return this.name;
    }

    public void addClass(IClass clazz) {
        this.classes.put(clazz.getName(), clazz);
    }

    public IClass getClass(String name) {
        return (IClass)this.classes.get(name);
    }

    public IClass[] getClasses() {
        IClass[] c = new IClass[this.classes.size()];
        int i = 0;
        Enumeration e = this.classes.keys();
        while (e.hasMoreElements()) {
            c[i++] = (IClass)this.classes.get(e.nextElement());
        }
        return c;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String packagePrefix) {
        StringBuffer s = new StringBuffer("Package: ");
        s.append(this.getName());
        s.append("\n");
        Enumeration e = this.classes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            IClass c = (IClass)this.classes.get(key);
            s.append(c.toString(packagePrefix));
            s.append("\n");
        }
        return s.toString();
    }
}

