/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Properties;
import java.util.Vector;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.IType;
import org.freehep.rtti.RTTI;

public class IMethod {
    private String name;
    private Vector comments;
    private boolean isStatic;
    private boolean isConst;
    private String[] templateParameters;
    private IType returnType;
    private INamedType[] parameterTypes;
    private String[] exceptionTypes;

    IMethod(String name, Vector comments, boolean isStatic, String[] templateParameters, IType returnType, boolean isConst, INamedType[] parameterTypes, String[] exceptionTypes) {
        this.name = name;
        this.comments = comments;
        this.isStatic = isStatic;
        this.templateParameters = templateParameters;
        this.returnType = returnType;
        this.isConst = isConst;
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = exceptionTypes;
    }

    public String getName() {
        return this.name;
    }

    public String[] getComments(String language) {
        return RTTI.getComments(this.comments, language);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String[] getTemplateParameters() {
        return this.templateParameters;
    }

    public IType getReturnType() {
        return this.returnType;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public INamedType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public String getSignature(String packageName, Properties imports) {
        StringBuffer s = new StringBuffer();
        s.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            s.append(this.parameterTypes[i].getSignature(packageName, imports));
        }
        s.append(")");
        s.append(this.returnType.getSignature(packageName, imports));
        return s.toString();
    }

    public String toString() {
        String[] exceptionTypes;
        StringBuffer s = new StringBuffer("");
        String[] comments = this.getComments(null);
        for (int i = 0; i < comments.length; ++i) {
            s.append(comments[i]);
        }
        s.append("\n");
        s.append(this.getSignature("", new Properties()));
        s.append("\n");
        s.append("    public ");
        if (this.isStatic()) {
            s.append("static ");
        }
        s.append(this.getReturnType());
        s.append(" ");
        s.append(this.getName());
        s.append(" (");
        INamedType[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            s.append(parameterTypes[i]);
            if (i >= parameterTypes.length - 1) continue;
            s.append(", ");
        }
        s.append(" )");
        if (this.isConst()) {
            s.append(" const");
        }
        if ((exceptionTypes = this.getExceptionTypes()).length > 0) {
            s.append(" throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                s.append(exceptionTypes[i]);
                if (i >= exceptionTypes.length - 1) continue;
                s.append(", ");
            }
        }
        s.append(";");
        return s.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof IMethod) {
            IMethod other = (IMethod)o;
            if (this.isStatic != other.isStatic) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (!this.returnType.equals(other.returnType)) {
                return false;
            }
            if (this.parameterTypes.length != other.parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i].equals(other.parameterTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

