/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.InvalidAccess;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSOutputFile;
import org.freehep.postscript.PSString;
import org.freehep.util.io.ASCIIHexOutputStream;

class WriteHexString
extends FileOperator {
    WriteHexString() {
        this.operandTypes = new Class[]{PSFile.class, PSString.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSString string = os.popString();
        PSFile file = os.popFile();
        try {
            if (!os.isSecure()) {
                throw new IOException();
            }
            ASCIIHexOutputStream out = new ASCIIHexOutputStream(((PSOutputFile)file).getOutputStream());
            for (int i = 0; i < string.size(); ++i) {
                ((OutputStream)out).write(string.get(i));
            }
        }
        catch (IOException e) {
            WriteHexString.error(os, new IOError());
        }
        catch (ClassCastException e) {
            WriteHexString.error(os, new InvalidAccess());
        }
        return true;
    }
}

